/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.builder;

import com.cognos.mobile.builder.DemoSettings;
import com.cognos.mobile.builder.IDemoBuilder;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.standardedition.FileHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RimOtaDemoBuilder
implements IDemoBuilder {
    String version = "4.1";

    public RimOtaDemoBuilder(String version) {
        this.version = version;
    }

    @Override
    public boolean needsIndexFile() {
        return false;
    }

    @Override
    public void buildDemo(DemoSettings demoSettings, String[] files, String tempDir, String outputDir) throws CMException {
        System.out.println("--- RIM OTA ---");
        String corePath = this.findCodPath(outputDir, "cognos_mobile");
        this.unzipCodFile(corePath, outputDir);
        String workingDir = "";
        if (!FileHelper.fileExists("cognos_mobile_template_" + this.version + ".cod")) {
            workingDir = "../_inst/tools/";
        }
        FileHelper.copyFileToFile(workingDir + "cognos_mobile_settings_template_" + this.version + ".cod", outputDir + "cognos_mobile_settings" + ".cod", System.out);
        String codPath = this.findCodPath(outputDir, "cognos_mobile_demo");
        String[] codFiles = this.unzipCodFile(codPath, outputDir);
        String jadFile = this.buildJadFile(workingDir + "cognos_mobile_template_" + this.version + ".jad", codFiles, outputDir);
        System.out.println("- " + jadFile);
    }

    private String buildJadFile(String templatePath, String[] codFiles, String outputDir) throws CMException {
        int index = 0;
        try {
            int i;
            String str;
            File templateFile = new File(templatePath);
            if (!templateFile.exists()) {
                throw new CMException(1000, "Unable to find template file: " + templatePath);
            }
            File jadFile = new File(outputDir + "cognos_mobile_demo" + ".jad");
            jadFile.createNewFile();
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader in = new BufferedReader(new FileReader(templatePath));
            while ((str = in.readLine()) != null) {
                if (str.startsWith("RIM-COD-URL-")) {
                    ++index;
                }
                if (str.startsWith("MIDlet-Name:")) {
                    lines.add("MIDlet-Name:Cognos Mobile with Demo Inbox");
                    continue;
                }
                lines.add(str);
            }
            ++index;
            in.close();
            BufferedWriter out = new BufferedWriter(new FileWriter(jadFile));
            for (i = 0; i < lines.size(); ++i) {
                out.write(lines.get(i).toString());
                out.newLine();
            }
            for (i = 0; i < codFiles.length; ++i) {
                File codFile = new File(outputDir + codFiles[i]);
                if (!codFile.exists()) {
                    throw new CMException(1000, "Missing *.cod file: " + codFiles[i]);
                }
                String id = Integer.toString(index + i);
                out.write("RIM-COD-URL-" + id + ": " + codFiles[i]);
                out.write("\r\n");
                out.write("RIM-COD-Size-" + id + ": " + codFile.length());
                out.write("\r\n");
            }
            out.close();
            return jadFile.getCanonicalPath();
        }
        catch (FileNotFoundException e) {
            throw new CMException(1000, e.toString());
        }
        catch (IOException e) {
            throw new CMException(1000, e.toString());
        }
    }

    private String findCodPath(String outputDir, String codName) throws CMException {
        String codPath = outputDir + "../rim_desktop_" + this.version + "/" + codName + ".cod";
        File codFile = new File(codPath);
        if (!codFile.exists()) {
            throw new CMException(1000, "*.cod file not found!  Expected to see it here: " + codPath);
        }
        try {
            codPath = codFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return codPath;
    }

    private String[] unzipCodFile(String codPath, String outputDir) throws CMException {
        ZipFile zf;
        try {
            zf = new ZipFile(codPath);
        }
        catch (IOException e) {
            FileHelper.copyFileToDir(codPath, outputDir, System.out);
            return new String[]{"cognos_mobile_demo.cod"};
        }
        Vector<String> codFileNames = new Vector<String>();
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.endsWith("/")) continue;
            System.out.println("- " + zipEntryName);
            OutputStream out = null;
            InputStream in = null;
            try {
                int len;
                out = new FileOutputStream(outputDir + zipEntryName);
                in = zf.getInputStream(zipEntry);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (IOException ex) {
                throw new CMException(1000, "failed to copy *.cod file: " + zipEntryName, (Throwable)ex);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            codFileNames.addElement(zipEntryName);
        }
        return codFileNames.toArray(new String[0]);
    }
}

