/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.builder;

import com.cognos.mobile.builder.BuilderHelper;
import com.cognos.mobile.standardedition.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SettingsBuilder {
    public static final Pattern JAD_REGEX = Pattern.compile("^\\s*(.*?)\\s*:\\s*(.*)\\s*$");
    private static final String c8Dir = BuilderHelper.guessC8Dir();
    private static PrintStream loggingStream = null;

    public abstract String buildSettings(Hashtable var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadJad(String filename) throws IOException {
        try (BufferedReader r = null;){
            r = new BufferedReader(new FileReader(filename));
            String line = null;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            while ((line = r.readLine()) != null) {
                Matcher m = JAD_REGEX.matcher(line);
                if (!m.lookingAt()) continue;
                map.put(m.group(1), m.group(2));
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
    }

    public static void saveAsProperties(Map h, PrintStream out, String separator) {
        for (String key : h.keySet()) {
            String value;
            if (key == null || (value = (String)h.get(key)) == null) continue;
            out.println(key + separator + value);
        }
    }

    public static void setLoggingStream(PrintStream loggingStream) {
        SettingsBuilder.loggingStream = loggingStream;
    }

    public static void log(String out) {
        if (loggingStream != null) {
            loggingStream.println(out);
        }
    }

    public static final String getC8Dir() {
        return c8Dir;
    }

    public abstract String getPlatform();

    public static String makeDirectories() throws Exception {
        FileHelper.makeDir(c8Dir + "/configuration");
        FileHelper.makeDir(c8Dir + "/configuration/mobile");
        FileHelper.makeDir(c8Dir + "/temp");
        File dir = new File(c8Dir + "/temp/_settings");
        if (dir.exists()) {
            FileHelper.deleteFiles(c8Dir + "/temp/_settings");
        }
        FileHelper.makeDir(c8Dir + "/temp/_settings");
        FileHelper.makeDir(c8Dir + "/temp/_settings/config");
        return dir.getCanonicalPath().replace('\\', '/');
    }
}

