/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.BaseCMQueryMachine;
import com.cognos.mobile.c8.C8CMClass;
import com.cognos.mobile.c8.C8ContentManagerQueryCommand;
import com.cognos.mobile.c8.C8PortalItemFactory;
import com.cognos.mobile.c8.ConsumerRooter;
import com.cognos.mobile.c8.ContentManagerBridge;
import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

class BiBusEnvelopeCMQueryMachine
extends BaseCMQueryMachine {
    private static final Class CLASS = BiBusEnvelopeCMQueryMachine.class;
    private final BIBusEnvelope biBusEnvelope;

    BiBusEnvelopeCMQueryMachine(BIBusEnvelope busEnvelope) {
        this.biBusEnvelope = busEnvelope;
    }

    @Override
    public C8.PortalItem[] findFromCMQuery(String cmQuery) throws CMException {
        try {
            return this.executeQuery(this.biBusEnvelope, cmQuery);
        }
        catch (CMException e) {
            VM.log(CLASS, 3, "query \"" + cmQuery + "\" failed: " + e.toString());
            throw e;
        }
        catch (Exception e) {
            String details = "query \"" + cmQuery + "\" failed: " + e.toString();
            VM.log(CLASS, 3, details);
            throw new CMException(1105, details);
        }
    }

    private C8.PortalItem[] executeQuery(BIBusEnvelope biBusEnvelope, String cmQuery) throws Exception {
        C8ContentManagerQueryCommand cmqc = new C8ContentManagerQueryCommand(cmQuery);
        cmqc.setBIBusHeader(biBusEnvelope.getBIBusHeader().createCopy());
        cmqc.addQueryPropertyName("defaultName");
        cmqc.addQueryPropertyName("searchPath");
        cmqc.addQueryPropertyName("storeID");
        cmqc.addQueryPropertyName("objectClass");
        cmqc.addQueryPropertyName("modificationTime");
        cmqc.addQueryPropertyName("permissions");
        cmqc.addQueryPropertyName("target");
        cmqc.addQueryPropertyName("options");
        cmqc.addQueryPropertyName("defaultDescription");
        cmqc.addQueryPropertyName("hidden");
        cmqc.addQueryPropertyName("base");
        cmqc.addQueryPropertyName("parent");
        cmqc.addSortPropertyName("defaultName");
        ContentManagerBridge.getInstance().executeCommand(cmqc);
        List<C8CMClass> resultList = cmqc.getResultList();
        ArrayList<C8.PortalItem> folders = new ArrayList<C8.PortalItem>();
        ArrayList<C8.PortalItem> reports = new ArrayList<C8.PortalItem>();
        block5: for (C8CMClass cmClass : resultList) {
            C8.PortalItem item;
            String parentType;
            if (cmClass.isParentTypeExcluded(parentType = cmClass.getParentType()) || (item = C8PortalItemFactory.getInstance().createPortalItem(cmClass)) == null || item.permissions == null || item.permissions.length == 0) continue;
            if (parentType != null && parentType.indexOf("dashboard") != -1) {
                item.itemType = 62;
            }
            switch (item.itemType) {
                case 50: {
                    continue block5;
                }
                case 58: 
                case 59: 
                case 64: {
                    folders.add(item);
                    continue block5;
                }
                case 55: {
                    Element targetEl = cmClass.getItemElement().element("target");
                    ArrayList<String> targets = new ArrayList<String>();
                    if (targetEl != null) {
                        Iterator it2 = targetEl.element("value").elementIterator("item");
                        while (it2.hasNext()) {
                            String v;
                            Element valueEl;
                            Element el = ((Element)it2.next()).element("searchPath");
                            if (el == null || (valueEl = el.element("value")) == null || (v = valueEl.getText()) == null) continue;
                            targets.add(v);
                        }
                    }
                    if (targets.size() == 1) {
                        item.targetCMPath = (String)targets.get(0);
                        item.handleShortcut();
                        item.sourcePath = ConsumerRooter.convertSearchPathToSourcePath(item.targetCMPath);
                        break;
                    }
                    item.itemType = 50;
                }
            }
            if (!item.isSupportedType()) continue;
            reports.add(item);
        }
        folders.addAll(reports);
        return folders.toArray(new C8.PortalItem[folders.size()]);
    }
}

