/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8Attachment;
import com.cognos.mobile.c8.C8AttachmentParser;
import com.cognos.mobile.c8.C8ByteArrayAttachment;
import com.cognos.mobile.c8.MemoPartComposite;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class C8AttatchmentParserImpl
implements C8AttachmentParser {
    private boolean isEmptyLine(InputStream inStream, StringBuffer strRead) throws IOException {
        boolean isEmptyLine = true;
        if (strRead == null) {
            strRead = new StringBuffer();
        }
        while (true) {
            int c = inStream.read();
            strRead.append((char)c);
            if (c == 13) continue;
            if (c == 10 || c == -1) break;
            isEmptyLine = false;
        }
        return isEmptyLine;
    }

    private String attchementIDToContentID(String contentType, String contentID, List<MemoPartComposite> memoParts) {
        if (!contentType.equals("image/png")) {
            return contentID;
        }
        for (int i = 0; i < memoParts.size(); ++i) {
            MemoPartComposite mp = memoParts.get(i);
            if (mp == null || !("cid:" + contentID).equals(mp.getAttachementID())) continue;
            return mp.getLocaleOrCID();
        }
        return contentID;
    }

    @Override
    public C8Attachment parseAttachment(InputStream mis, List<MemoPartComposite> memoParts) throws IOException {
        StringBuffer readSoFar = new StringBuffer();
        while (!this.isEmptyLine(mis, readSoFar)) {
        }
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(readSoFar.toString().getBytes("UTF-8")));
        String contentIDPropertyValue = p.getProperty("Content-ID");
        String encoding = p.getProperty("Content-Encoding");
        String contentType = p.getProperty("Content-Type");
        String contentID = this.attchementIDToContentID(contentType, contentIDPropertyValue, memoParts);
        C8ByteArrayAttachment attachment = new C8ByteArrayAttachment(mis, contentID, encoding, contentType);
        return attachment;
    }
}

