/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8SOAPMessageOutputter;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.standardedition.DOM4JUtil;
import com.cognos.mobile.vm.VM;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPXMLSource;
import com.cognos.pogo.util.Check;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Header;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class C8BIBusCommand
implements Cleanable {
    private static final Class CLASS = C8BIBusCommand.class;
    private static final String TEXT_XML = "text/xml";
    public static final Namespace BUS_NAMESPACE = new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    protected static final QName BUS_MESSAGE = new QName("message", BUS_NAMESPACE);
    protected static final QName BUS_EXCEPTION = new QName("exception", BUS_NAMESPACE);
    protected static final QName BUS_PROVIDER = new QName("provider", BUS_NAMESPACE);
    private static final Namespace NS_FAULTS = Namespace.get((String)"faults", (String)"http://www.w3.org/2001/09/soap-faults");
    private static final QName FAULTS_MISUNDERSTOOD = DOM4JUtil.df.createQName("Misunderstood", NS_FAULTS);
    protected static final QName BUS_CAMTRUSTEDPROCESS = new QName("CAMTrustedprocess", BUS_NAMESPACE);
    public static final QName BUS_USERPREFERENCE = new QName("userPreference", BUS_NAMESPACE);
    public static final QName BUS_VAR = new QName("var", BUS_NAMESPACE);
    protected static final String PROVIDER_NAME_ATTRIBUTE = "name";
    protected static final String PROVIDER_PATCH_ATTRIBUTE = "patch";
    protected static final String CAMTRUSTEDPROCESS_NAME_ATTRIBUTE = "name";
    protected static final String CAMTRUSTEDPROCESS_DISPATCHER = "dispatcher";
    public static final String VAR_NAME_ATTRIBUTE = "name";
    public static final String VAR_VALUE_ATTRIBUTE = "value";
    protected static final String ERRORCODE = "errorCode";
    protected static final String ERRORCODESTRING = "errorCodeString";
    protected static final String SEVERITY = "severity";
    protected static final String DETAIL = "detail";
    private BIBusEnvelope requestEnvelope;
    private BIBusEnvelope responseEnvelope;
    private ServerConnection connection;
    private boolean autoRelease = true;
    private boolean doTrustedRequest = false;
    private boolean responseReceived = false;
    private boolean autoRetry = true;
    private String serviceID = "DISP";
    private Iterator multiPartAttachments = Collections.EMPTY_LIST.iterator();
    private String multiPartBoundary = null;
    private Iterator requestAttachments = Collections.EMPTY_LIST.iterator();
    private int statusCode;
    private String statusString;
    private static Object counterLock = new Object();
    private static String debugMessageDumpDirectory = null;
    private static int counter = 1000;

    public C8BIBusCommand() {
        this.requestEnvelope = C8BIBusCommand.createBlankEnvelope();
    }

    public static void setDebugMessageDumpDirectory(String dir) {
        debugMessageDumpDirectory = dir;
    }

    private boolean isEmptyLine(InputStream inStream) throws IOException {
        boolean isEmptyLine = true;
        while (true) {
            int aByte;
            if ((aByte = inStream.read()) == 13) {
                continue;
            }
            if (aByte == 10 || aByte == -1) break;
            isEmptyLine = false;
        }
        return isEmptyLine;
    }

    private InputStream stripMIMEHeaders(InputStream inStream) throws IOException {
        while (!this.isEmptyLine(inStream)) {
        }
        VM.log(CLASS, 0, "Consumed all HTTP headers in the MIME part");
        return inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws CMException {
        BIBusEnvelope anEnvelope = this.getRequestEnvelope();
        this.executeImpl(anEnvelope.getBody());
        anEnvelope = this.getRequestEnvelope();
        this.addExtraSOAPHeaders();
        this.connection = this.fetchServerConnection();
        this.connection.setAutoRetry(this.isAutoRetry());
        this.addExtraHTTPHeaders(this.connection);
        int messageNumber = 0;
        try {
            InputStream inStream;
            C8SOAPMessageOutputter messageOutputter = new C8SOAPMessageOutputter((SOAPXMLSource)anEnvelope, this.requestAttachments, null);
            this.connection.setRequestContentType(messageOutputter.getContentType());
            messageOutputter.setDoTrustedRequest(this.doTrustedRequest, this.serviceID);
            this.connection.setRequestBodySource((MsgBodyGenerator)new SOAPBodyGenerator(messageOutputter));
            if (debugMessageDumpDirectory != null) {
                Object object = counterLock;
                synchronized (object) {
                    messageNumber = counter++;
                }
                try {
                    FileOutputStream fos = new FileOutputStream(debugMessageDumpDirectory + "/msg-" + Integer.toString(messageNumber) + "-request.txt");
                    XMLWriter xmlw = new XMLWriter((OutputStream)fos);
                    xmlw.write(this.requestEnvelope.getEnvelope());
                    xmlw.close();
                    fos.close();
                }
                catch (Throwable t) {
                    System.out.println(t.toString());
                }
            }
            this.statusCode = this.connection.sendRequest(this.fetchRequestContext());
            this.statusString = this.connection.getStatusText();
            if (this.statusCode == 304) {
                this.responseReceived = true;
                this.handleResponseMIMEHeaders(this.connection.getResponseHeaders());
                return;
            }
            int contentLength = -1;
            if (this.connection.isMultiPart()) {
                Iterator it = this.connection.iterator();
                inStream = this.stripMIMEHeaders((InputStream)it.next());
                this.multiPartAttachments = it;
                this.multiPartBoundary = this.connection.getMultiPartBoundary();
            } else {
                inStream = this.connection.getInputStream();
                this.checkResponseContentType(this.connection, inStream);
                Header[] responseHeaders = this.connection.getResponseHeaders();
                for (int i = 0; i < responseHeaders.length; ++i) {
                    if (!"Content-Length".equalsIgnoreCase(responseHeaders[i].getName())) continue;
                    try {
                        contentLength = Integer.parseInt(responseHeaders[i].getValue());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.responseReceived = true;
            this.handleResponseMIMEHeaders(this.connection.getResponseHeaders());
            this.responseEnvelope = contentLength != -1 ? new BIBusEnvelope((InputStream)new ContentLengthInputStream(inStream, contentLength)) : new BIBusEnvelope(inStream);
            this.handleResponse();
        }
        catch (CMException ex) {
            if (VM.wouldLog(CLASS, 0)) {
                this.logFault(this.responseEnvelope);
            }
            if (this.checkForInactiveCM()) {
                this.connection.setBadInputStream();
            }
            throw ex;
        }
        catch (IOException ex) {
            if (VM.wouldLog(CLASS, 0)) {
                VM.log(CLASS, 0, C8BIBusCommand.getContext(this.responseEnvelope) + "IOException occured while executing BIBus cmd:", ex);
            }
            this.connection.setBadInputStream();
            throw new CMException(1162, (Throwable)ex);
        }
        catch (Exception ex) {
            if (VM.wouldLog(CLASS, 0)) {
                VM.log(CLASS, 0, C8BIBusCommand.getContext(this.responseEnvelope) + "exception occured while executing BIBus cmd:", ex);
            }
            this.connection.setBadInputStream();
            throw new CMException(1162, (Throwable)ex);
        }
        finally {
            if (debugMessageDumpDirectory != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(debugMessageDumpDirectory + "/msg-" + Integer.toString(messageNumber) + "-response.txt");
                    XMLWriter xmlw = new XMLWriter((OutputStream)fos);
                    xmlw.write(this.responseEnvelope.getEnvelope());
                    xmlw.close();
                    fos.close();
                }
                catch (Throwable t) {
                    System.out.println(t.toString());
                }
            }
            if (this.autoRelease) {
                this.connection.release();
            }
        }
    }

    private void logFault(BIBusEnvelope responseEnvelope) {
        StringWriter sw = new StringWriter();
        Element faultElement = responseEnvelope.getFault();
        boolean showHeader = false;
        if (faultElement == null) {
            sw.write(" (no fault)");
        } else {
            Iterator it = faultElement.elementIterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                if (e.getName().equals("faultcode")) {
                    sw.write(" (faultcode '" + e.getTextTrim() + "')");
                    continue;
                }
                if (e.getName().equals("faultstring")) {
                    sw.write(" (faultstring '" + e.getTextTrim() + "')");
                    continue;
                }
                if (e.getName().equals(DETAIL)) {
                    Iterator it2 = e.elementIterator();
                    while (it2.hasNext()) {
                        Element e2 = (Element)it2.next();
                        if (e2.getName().equals("exception")) {
                            Iterator it3 = e2.elementIterator();
                            while (it3.hasNext()) {
                                Element e3 = (Element)it3.next();
                                if (e3.getName().equals(SEVERITY)) {
                                    sw.write(" (bus-error-severity '" + e3.getTextTrim() + "')");
                                    continue;
                                }
                                if (e3.getName().equals(ERRORCODE)) {
                                    sw.write(" (bus-error-code '" + e3.getTextTrim() + "')");
                                    continue;
                                }
                                if (e3.getName().equals("message")) {
                                    Iterator it4 = e3.elementIterator();
                                    while (it4.hasNext()) {
                                        Element e4 = (Element)it4.next();
                                        sw.write(" (bus-error-msg '" + e4.getTextTrim() + "')");
                                        if (!e4.getText().startsWith("CM-REQ-4159")) continue;
                                        showHeader = true;
                                    }
                                    continue;
                                }
                                XMLWriter writer = new XMLWriter((Writer)sw, new OutputFormat("", true));
                                sw.write(" (unknown element '" + e3.getName() + "', '");
                                try {
                                    writer.write(e3);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                sw.write("')");
                            }
                            continue;
                        }
                        XMLWriter writer = new XMLWriter((Writer)sw, new OutputFormat("", true));
                        sw.write(" (unknown element '" + e2.getName() + "', '");
                        try {
                            writer.write(e2);
                        }
                        catch (Exception e3) {
                            // empty catch block
                        }
                        sw.write("')");
                    }
                    continue;
                }
                XMLWriter writer = new XMLWriter((Writer)sw, new OutputFormat("", true));
                sw.write(" (unknown element '" + e.getName() + "', '");
                try {
                    writer.write(e);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                sw.write("')");
            }
        }
        VM.log(CLASS, 1, C8BIBusCommand.getContext(responseEnvelope) + "SOAP fault:" + sw.toString());
        if (showHeader) {
            Element e = responseEnvelope.getCAM();
            Element exe = e.element("exception");
            if (exe == null) {
                VM.log(CLASS, 1, C8BIBusCommand.getContext(responseEnvelope) + "Unrecognized error in header; dumping entire header:\n" + DOM4JUtil.prettyPrint(responseEnvelope.getHeader()));
            } else {
                sw = new StringWriter();
                Iterator it3 = exe.elementIterator();
                while (it3.hasNext()) {
                    Element e3 = (Element)it3.next();
                    if (e3.getName().equals(SEVERITY)) {
                        sw.write(" (CAM-error-severity '" + e3.getTextTrim() + "')");
                        continue;
                    }
                    if (e3.getName().equals(ERRORCODESTRING)) {
                        sw.write(" (CAM-error-code-string '" + e3.getTextTrim() + "')");
                        continue;
                    }
                    if (!e3.getName().equals("messages")) continue;
                    Iterator it4 = e3.elementIterator();
                    while (it4.hasNext()) {
                        Element e5;
                        Element e4 = (Element)it4.next();
                        if (!e4.getName().equals("item") || (e5 = e4.element("messageString")) == null) continue;
                        sw.write(" (CAM-msg-string '" + e5.getTextTrim() + "')");
                    }
                }
                VM.log(CLASS, 1, C8BIBusCommand.getContext(responseEnvelope) + "CAM error: " + sw.toString());
            }
        }
    }

    public static String getContext(BIBusEnvelope b) {
        if (b != null) {
            StringBuffer sb = new StringBuffer();
            String c = b.getSessionContext();
            if (c != null) {
                sb.append(" " + c + " ");
            } else {
                sb.append(" - ");
            }
            c = b.getRequestContext();
            if (c != null) {
                sb.append(" " + c + " ");
            } else {
                sb.append(" - ");
            }
            return sb.toString();
        }
        return " - - ";
    }

    protected boolean checkForInactiveCM() {
        return false;
    }

    private void checkResponseContentType(ServerConnection connection, InputStream inStream) throws CMException, IOException {
        String responseContentType = connection.getResponseContentType();
        if (responseContentType == null || !responseContentType.startsWith(TEXT_XML)) {
            String errorMessage = DispatcherStrings.getInstance().getString("BIBusCommand.badMIMEType");
            if (inStream != null) {
                DataInputStream dataStream = new DataInputStream(inStream);
                byte[] data = new byte[inStream.available()];
                dataStream.readFully(data);
                errorMessage = errorMessage + new String(data, "UTF-8");
            }
            throw new CMException(1162, errorMessage);
        }
    }

    public Iterator getAttachments() {
        return this.multiPartAttachments;
    }

    public String getBoundary() {
        return this.multiPartBoundary;
    }

    protected void addExtraSOAPHeaders() {
    }

    protected void addExtraHTTPHeaders(ServerConnection connection) {
    }

    public void addToHeader(Element anElement) throws IllegalAddException {
        Check.notNull((Object)anElement);
        Element headerElement = this.requestEnvelope.getBIBusHeader();
        headerElement.add(anElement);
    }

    public void setBIBusHeader(Element biBusHeaderElement) throws IllegalAddException {
        Check.notNull((Object)biBusHeaderElement);
        Element headerElement = this.requestEnvelope.getHeader();
        Element currentBIBusHeader = headerElement.element(BIBusEnvelope.BUS_BIBUS_HEADER);
        if (currentBIBusHeader != null) {
            currentBIBusHeader.detach();
        }
        headerElement.add(biBusHeaderElement);
    }

    protected Element getResponseHeaderElement(String name) throws NoSuchElementException {
        Check.notNull((Object)name);
        Element responseHeader = this.responseEnvelope.getBIBusHeader();
        Element headerElement = responseHeader.element(name);
        if (headerElement == null) {
            throw new NoSuchElementException(DispatcherStrings.getInstance().getString("BIBusCommand.missingHeader") + name);
        }
        return headerElement;
    }

    public Element getRequestCAMElement() {
        return this.requestEnvelope.getCAM();
    }

    public void addCAMElement(Element camElement) {
        Check.notNull((Object)camElement);
        this.addToHeader(camElement);
    }

    private void handleResponse() throws CMException {
        String ms;
        if (this.responseEnvelope == null) {
            VM.log(CLASS, 3, "Logic problem, handleResponse called on null response envelope.");
            throw new CMException(1162, "handleResponse() called on null response envelope.");
        }
        Element misunderstood = this.responseEnvelope.getHeader().element(FAULTS_MISUNDERSTOOD);
        if (misunderstood != null && (ms = misunderstood.asXML()).indexOf("cmAuthenticateFailed") > 0) {
            throw new CMException(1112);
        }
        Element soapFault = this.responseEnvelope.getFault();
        if (soapFault != null) {
            Element camException;
            Element cam = this.responseEnvelope.getCAM();
            if (cam != null && (camException = cam.element("exception")) != null) {
                VM.log(CLASS, 1, C8BIBusCommand.getContext(this.responseEnvelope) + "CAM error; returning error to caller");
                throw new CMException(1112, this.responseEnvelope);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(DispatcherStrings.getInstance().getString("BIBusCommand.soapFaultFound"));
            if (this.responseEnvelope.getFaultDetail() != null) {
                sb.append(this.responseEnvelope.getFaultDetail().asXML());
            } else {
                sb.append("--no details--");
            }
            throw new CMException(1162, sb.toString());
        }
        Element bodyElement = this.responseEnvelope.getBody();
        if (bodyElement != null) {
            this.handleResponseImpl(bodyElement);
        } else {
            VM.log(CLASS, 2, C8BIBusCommand.getContext(this.responseEnvelope) + "Received SOAP response with no body!");
            VM.log(CLASS, 0, C8BIBusCommand.getContext(this.responseEnvelope) + "SOAPResponse with no Body:\n" + this.responseEnvelope.getAsDocument().asXML());
        }
    }

    protected void handleResponseMIMEHeaders(Header[] headers) {
    }

    private static BIBusEnvelope createBlankEnvelope() {
        BIBusEnvelope anEnvelope = new BIBusEnvelope();
        return anEnvelope;
    }

    public BIBusEnvelope getRequestEnvelope() {
        return this.requestEnvelope;
    }

    protected void setRequestEvelope(BIBusEnvelope envelope) {
        Check.notNull((Object)envelope);
        this.requestEnvelope = envelope;
    }

    public BIBusEnvelope getResponseEnvelope() {
        return this.responseEnvelope;
    }

    public void setResponseEnvelope(BIBusEnvelope envelope, boolean handleResponse) {
        this.responseEnvelope = envelope;
        if (handleResponse) {
            try {
                this.handleResponseImpl(this.responseEnvelope.getBody());
            }
            catch (CMException cm) {
                throw new RuntimeException(cm.getMessage(), cm);
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setRequestAttachments(Iterator anIterator) {
        Check.notNull((Object)anIterator);
        this.requestAttachments = anIterator;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setAutoRelease(boolean release) {
        this.autoRelease = release;
    }

    public void setLargeResponseHint() {
    }

    protected abstract void executeImpl(Element var1) throws CMException;

    protected abstract void handleResponseImpl(Element var1) throws CMException;

    protected abstract ServerConnection fetchServerConnection();

    protected abstract String fetchRequestContext();

    public void clean(MessageContext mc) {
        if (!this.autoRelease) {
            if (mc.isFaulted()) {
                this.connection.setBadInputStream();
            }
            this.connection.release();
        }
    }

    public void setDoTrustedRequest(boolean doTrustedRequest) {
        this.setDoTrustedRequest(doTrustedRequest, "DISP");
    }

    public void setDoTrustedRequest(boolean doTrustedRequest, String serviceID) {
        this.doTrustedRequest = doTrustedRequest;
        if (serviceID != null) {
            this.serviceID = serviceID;
        }
    }

    public boolean isResponseReceived() {
        return this.responseReceived;
    }

    private boolean isAutoRetry() {
        return this.autoRetry;
    }

    public void setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
    }

    private class SOAPBodyGenerator
    implements MsgBodyGenerator {
        C8SOAPMessageOutputter messageOutputter;

        SOAPBodyGenerator(C8SOAPMessageOutputter messageOutputter) {
            this.messageOutputter = messageOutputter;
        }

        public void writeBody(OutputStream os) throws IOException {
            this.messageOutputter.setOutputStream(os);
            this.messageOutputter.write();
        }

        public boolean rewind() {
            return this.messageOutputter.canResend();
        }
    }
}

