/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8Attachment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

public class C8ByteArrayAttachment
extends C8Attachment {
    private byte[] buffer;

    C8ByteArrayAttachment(InputStream in, String contentID, String encoding, String contentType) throws IOException {
        super(contentID, encoding, contentType);
        this.size = this.Load(in);
    }

    private boolean isContentCompressed() {
        return this.getContentEncoding() != null && this.getContentEncoding().equals("gzip");
    }

    public InputStream getInputStream() throws IOException {
        if (this.buffer != null && this.isContentCompressed()) {
            return new GZIPInputStream(new ByteArrayInputStream(this.buffer));
        }
        return new ByteArrayInputStream(this.buffer);
    }

    private int Load(InputStream ins) throws IOException {
        int read;
        ByteArrayOutputStream outBytes;
        ByteArrayOutputStream out = outBytes = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((read = ins.read(buf)) != -1) {
            ((OutputStream)out).write(buf, 0, read);
            this.size += read;
        }
        byte[] fileContents = outBytes.toByteArray();
        this.buffer = fileContents;
        return this.size;
    }
}

