/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.DeliveryService_PortType;
import com.cognos.developer.schemas.bibus._3.EventManagementService_PortType;
import com.cognos.developer.schemas.bibus._3.IndexSearchService_PortType;
import com.cognos.developer.schemas.bibus._3.IndexSearchService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.mobile.c8.C8ConnectionFromBIBusHeader;
import com.cognos.mobile.c8.C8ConnectionFromCredentials;
import com.cognos.mobile.c8.factory.CognosServiceFactory;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Element;

public abstract class C8Connection {
    private static Class<C8Connection> CLASS = C8Connection.class;
    protected static String BI_BUS_HEADER = "biBusHeader";
    protected static String BI_BUS_NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    protected SoftReference<ContentManagerService_PortType> _cmService = null;
    protected SoftReference<EventManagementService_PortType> _eventManagementService = null;
    protected SoftReference<ReportService_PortType> _reportService = null;
    protected SoftReference<IndexSearchService_PortType> _idxSearchService = null;
    protected SoftReference<DeliveryService_PortType> _deliveryService = null;
    protected CAM _cam = null;
    protected URL dispatcherUrl = null;

    public static C8Connection fromCredentials(String c8DispatcherUrl, String namespace, String username, String password) throws CMException {
        return new C8ConnectionFromCredentials(c8DispatcherUrl, username, password, namespace);
    }

    public static C8Connection fromBiBusEnvelope(String c8DispatcherUrl, BIBusEnvelope biBusEnvelope) throws CMException {
        return new C8ConnectionFromBIBusHeader(c8DispatcherUrl, biBusEnvelope);
    }

    protected C8Connection(String c8DispatcherUrl) throws CMException {
        if (c8DispatcherUrl == null || c8DispatcherUrl.length() == 0) {
            throw new IllegalArgumentException("no dispatcher URL provided");
        }
        try {
            this.dispatcherUrl = new URL(c8DispatcherUrl);
        }
        catch (MalformedURLException e) {
            String details = "URL is malformed: " + c8DispatcherUrl;
            VM.log(CLASS, 3, details, e);
            throw new CMException(1006, new String[]{c8DispatcherUrl}, details, e);
        }
    }

    public void logoff() throws CMException {
        try {
            VM.log(CLASS, 1, "logging off...");
            this.getCMService().logoff();
            VM.log(CLASS, 1, "logged off");
        }
        catch (Exception ex) {
            String details = "failed to logoff";
            VM.log(CLASS, 3, details, ex);
            throw new CMException(1104, details, (Throwable)ex);
        }
    }

    public abstract ContentManagerService_PortType getCMService() throws CMException;

    public ReportService_PortType getReportService() throws CMException {
        ReportService_PortType rs = null;
        if (this._reportService != null) {
            rs = this._reportService.get();
        }
        if (rs == null) {
            try {
                rs = CognosServiceFactory.getInstance().createReportService(this.dispatcherUrl);
                this._reportService = new SoftReference<ReportService_PortType>(rs);
            }
            catch (ServiceException e) {
                this.handleServiceException(e);
            }
        }
        this.getBiBusHeader((Remote)rs);
        return rs;
    }

    public IndexSearchService_PortType getIndexSearchService() throws CMException {
        IndexSearchService_PortType ids = null;
        if (this._idxSearchService != null) {
            ids = this._idxSearchService.get();
        }
        if (ids == null) {
            try {
                ids = new IndexSearchService_ServiceLocator().getindexSearchService(this.dispatcherUrl);
                this._idxSearchService = new SoftReference<IndexSearchService_PortType>(ids);
            }
            catch (ServiceException e) {
                this.handleServiceException(e);
            }
        }
        this.getBiBusHeader((Remote)ids);
        return ids;
    }

    public BiBusHeader getBiBusHeader(Remote service) throws CMException {
        SOAPHeaderElement temp;
        BiBusHeader bibus = null;
        try {
            temp = ((Stub)service).getResponseHeader(BI_BUS_NAMESPACE, BI_BUS_HEADER);
            bibus = (BiBusHeader)temp.getValueAsType(new QName(BI_BUS_NAMESPACE, BI_BUS_HEADER));
            if (bibus != null) {
                C8Connection.setBiBusHeader(service, bibus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bibus == null && service != this.getCMService()) {
            try {
                temp = ((Stub)this.getCMService()).getResponseHeader(BI_BUS_NAMESPACE, BI_BUS_HEADER);
                bibus = (BiBusHeader)temp.getValueAsType(new QName(BI_BUS_NAMESPACE, BI_BUS_HEADER));
                CAM cam = bibus.getCAM();
                CAMPassport cPassport = null;
                if (cam != null) {
                    cPassport = cam.getCAMPassport();
                }
                if (cPassport == null && this._cam != null) {
                    bibus.setCAM(this._cam);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bibus != null) {
                C8Connection.setBiBusHeader(service, bibus);
            }
        }
        return bibus;
    }

    public static void setBiBusHeader(Remote service, BiBusHeader bibus) {
        ((Stub)service).clearHeaders();
        ((Stub)service).setHeader(BI_BUS_NAMESPACE, BI_BUS_HEADER, (Object)bibus);
    }

    public void setUserPreferences(Remote service, Element eUserPrefs) throws CMException {
        BiBusHeader bibus = this.getBiBusHeader(service);
        if (eUserPrefs != null) {
            UserPreferenceVar[] uPrefs = new UserPreferenceVar[eUserPrefs.elements("item").size()];
            Iterator it = eUserPrefs.elementIterator("item");
            int iCount = 0;
            while (it.hasNext()) {
                UserPreferenceVar uVar = new UserPreferenceVar();
                Element eNode = (Element)it.next();
                Element eName = eNode.element("name");
                Element eValue = eNode.element("value");
                if (eName != null) {
                    uVar.setName(eName.getText());
                }
                if (eValue != null) {
                    uVar.setValue(eValue.getText());
                }
                uPrefs[iCount] = uVar;
                ++iCount;
            }
            if (uPrefs.length != 0) {
                bibus.setUserPreferenceVars(uPrefs);
            }
        }
        C8Connection.setBiBusHeader(service, bibus);
    }

    public Object[] getAttachments(Remote service) {
        Object[] attachments = null;
        attachments = ((Stub)service).getAttachments();
        return attachments;
    }

    protected void handleServiceException(ServiceException ex) throws CMException {
        String details = "service failed";
        VM.log(CLASS, 3, details, ex);
        throw new CMException(1114, details, (Throwable)ex);
    }
}

