/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.Shortcut;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnumArrayProp;
import com.cognos.mobile.c8.BaseCMQueryMachine;
import com.cognos.mobile.c8.C8Connection;
import com.cognos.mobile.c8.C8PortalItemFactory;
import com.cognos.mobile.c8.ConsumerRooter;
import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import java.util.ArrayList;

public class C8ConnectionCMQueryMachine
extends BaseCMQueryMachine {
    private static final Class CLASS = C8ConnectionCMQueryMachine.class;
    private final C8Connection c8Connection;

    public C8ConnectionCMQueryMachine(C8Connection connection) {
        this.c8Connection = connection;
    }

    @Override
    public C8.PortalItem[] findFromCMQuery(String cmQuery) throws CMException {
        try {
            return this.executeQuery(this.c8Connection, cmQuery);
        }
        catch (Exception e) {
            String details = "query \"" + cmQuery + "\" failed";
            VM.log(CLASS, 3, details, e);
            throw new CMException(1105, details, (Throwable)e);
        }
    }

    public boolean isAdministrator() throws CMException {
        try {
            SearchPathMultipleObject cmSearchPathObject = new SearchPathMultipleObject("~~");
            PropEnum[] props = new PropEnum[]{PropEnum.userCapabilities};
            Sort[] sort = new Sort[]{};
            BaseClass[] cmResults = this.c8Connection.getCMService().query(cmSearchPathObject, props, sort, new QueryOptions());
            for (int i = 0; i < cmResults.length; ++i) {
                if (!(cmResults[i] instanceof Session)) continue;
                Session sf = (Session)cmResults[i];
                UserCapabilityEnumArrayProp prop = sf.getUserCapabilities();
                UserCapabilityEnum[] capabilities = prop.getValue();
                for (int j = 0; j < capabilities.length; ++j) {
                    if (UserCapabilityEnum.canUseServerAdministrationTool != capabilities[j]) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            String details = "query isAdministrator failed";
            VM.log(CLASS, 3, details, e);
            throw new CMException(1105, details, (Throwable)e);
        }
    }

    private C8.PortalItem[] executeQuery(C8Connection c8Connection, String cmQuery) throws Exception {
        SearchPathMultipleObject cmSearchPathObject = new SearchPathMultipleObject(cmQuery);
        PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.objectClass, PropEnum.permissions, PropEnum.storeID, PropEnum.target, PropEnum.options, PropEnum.modificationTime, PropEnum.base};
        Sort sortName = new Sort();
        sortName.setPropName(PropEnum.defaultName);
        sortName.setOrder(OrderEnum.ascending);
        Sort[] sort = new Sort[]{sortName};
        BaseClass[] cmResults = c8Connection.getCMService().query(cmSearchPathObject, props, sort, new QueryOptions());
        ArrayList<C8.PortalItem> results = new ArrayList<C8.PortalItem>();
        block4: for (int i = 0; i < cmResults.length; ++i) {
            C8.PortalItem item = C8PortalItemFactory.getInstance().createPortalItem(cmResults[i]);
            switch (item.itemType) {
                case 50: {
                    continue block4;
                }
                case 55: {
                    if (cmResults[i] instanceof Shortcut) {
                        BaseClass[] targetValues = null;
                        targetValues = ((Shortcut)cmResults[i]).getTarget().getValue();
                        if (targetValues != null && targetValues.length == 1) {
                            item.targetCMPath = targetValues[0].getSearchPath().getValue();
                            if (item.cmPath == null || item.cmPath.length() == 0) {
                                item.itemType = 50;
                            }
                        } else {
                            item.itemType = 50;
                        }
                    }
                }
                default: {
                    item.sourcePath = ConsumerRooter.convertSearchPathToSourcePath(item.cmPath);
                    results.add(item);
                }
            }
        }
        return results.toArray(new C8.PortalItem[results.size()]);
    }
}

