/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.mobile.c8.C8Connection;
import com.cognos.mobile.c8.factory.CognosServiceFactory;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.lang.ref.SoftReference;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Element;

public class C8ConnectionFromBIBusHeader
extends C8Connection {
    private Class<C8ConnectionFromBIBusHeader> CLASS = C8ConnectionFromBIBusHeader.class;
    private BIBusEnvelope _biBusEnvelope = null;

    public C8ConnectionFromBIBusHeader(String c8Url, BIBusEnvelope env) throws CMException {
        super(c8Url);
        this._biBusEnvelope = env;
    }

    @Override
    public ContentManagerService_PortType getCMService() throws CMException {
        ContentManagerService_PortType cms = null;
        if (this._cmService != null) {
            cms = (ContentManagerService_PortType)this._cmService.get();
        }
        if (cms == null) {
            try {
                cms = CognosServiceFactory.getInstance().createCMService(this.dispatcherUrl);
                this._cmService = new SoftReference<ContentManagerService_PortType>(cms);
                this.populateBiBusHeader(cms, this._biBusEnvelope);
            }
            catch (ServiceException e) {
                this.handleServiceException(e);
            }
            catch (RemoteException e) {
                String details = "service failed";
                VM.log(this.CLASS, 3, details, e);
                throw new CMException(1114, details, (Throwable)e);
            }
        }
        return cms;
    }

    private boolean isPassportOutofSync(BiBusHeader bibus, BIBusEnvelope env) {
        try {
            CAMPassport passport = bibus.getCAM().getCAMPassport();
            if (passport == null) {
                return false;
            }
            return !env.getPassportID().equals(passport.getId());
        }
        catch (Exception e) {
            return true;
        }
    }

    private void populateBiBusHeader(ContentManagerService_PortType cm, BIBusEnvelope requestEnvelope) throws RemoteException, CMException {
        BiBusHeader bibusHeader = this.queryServiceBibusHeader(cm);
        if (this.isPassportOutofSync(bibusHeader, requestEnvelope)) {
            VM.log(this.CLASS, 0, "cm passport is not consistent with request passport, trying to reset it");
            this.resetServicePassport(cm, requestEnvelope, bibusHeader);
            bibusHeader = this.queryServiceBibusHeader(cm);
        }
        if (bibusHeader != null) {
            this.copyPassport(requestEnvelope, bibusHeader);
            this.copyCookieVar(requestEnvelope, bibusHeader);
            this.copyUserPerf(requestEnvelope, bibusHeader);
            C8Connection.setBiBusHeader((Remote)cm, bibusHeader);
            this._cam = bibusHeader.getCAM();
        }
    }

    private void copyUserPerf(BIBusEnvelope requestEnvelope, BiBusHeader bibusHeader) {
        Element eUserPrefs = requestEnvelope.getUserPreferenceVars();
        if (eUserPrefs != null) {
            UserPreferenceVar[] uPrefs = new UserPreferenceVar[eUserPrefs.elements("item").size()];
            Iterator it = eUserPrefs.elementIterator("item");
            int iCount = 0;
            while (it.hasNext()) {
                UserPreferenceVar uVar = new UserPreferenceVar();
                Element eNode = (Element)it.next();
                Element eName = eNode.element("name");
                Element eValue = eNode.element("value");
                if (eName != null) {
                    uVar.setName(eName.getText());
                }
                if (eValue != null) {
                    uVar.setValue(eValue.getText());
                }
                uPrefs[iCount] = uVar;
                ++iCount;
            }
            if (uPrefs.length != 0) {
                bibusHeader.setUserPreferenceVars(uPrefs);
            }
        }
    }

    private void copyCookieVar(BIBusEnvelope requestEnvelope, BiBusHeader bibusHeader) {
        Element eCookieVars = requestEnvelope.getCookieVars();
        if (eCookieVars != null) {
            CookieVar[] cVars = new CookieVar[eCookieVars.elements("item").size()];
            Iterator itCookies = eCookieVars.elementIterator("item");
            int iCookieCount = 0;
            while (itCookies.hasNext()) {
                CookieVar cCookie = new CookieVar();
                Element eCookieNode = (Element)itCookies.next();
                Element eCookieName = eCookieNode.element("name");
                Element eCookieValue = eCookieNode.element("value");
                if (eCookieName != null) {
                    cCookie.setName(eCookieName.getTextTrim());
                }
                if (eCookieValue != null) {
                    cCookie.setValue(eCookieValue.getTextTrim());
                }
                cVars[iCookieCount] = cCookie;
                ++iCookieCount;
            }
            if (bibusHeader.getHdrSession() == null) {
                bibusHeader.setHdrSession(new HdrSession());
            }
            bibusHeader.getHdrSession().setCookieVars(cVars);
        }
    }

    private void copyPassport(BIBusEnvelope requestEnvelope, BiBusHeader bibusHeader) {
        CAM cSecurity = bibusHeader.getCAM();
        CAMPassport cPassport = null;
        if (cSecurity != null) {
            cPassport = cSecurity.getCAMPassport();
        } else {
            cSecurity = new CAM();
        }
        if (null == cPassport) {
            cPassport = new CAMPassport();
        }
        cPassport.setId(requestEnvelope.getPassportID());
        cSecurity.setCAMPassport(cPassport);
        if (cSecurity.getException() != null) {
            cSecurity.setException(null);
        }
    }

    private void resetServicePassport(ContentManagerService_PortType cm, BIBusEnvelope env, BiBusHeader header) {
        try {
            CAM cam = header.getCAM();
            CAMPassport passport = new CAMPassport();
            passport.setId(env.getPassportID());
            cam.setCAMPassport(passport);
            ((Stub)cm).clearHeaders();
            ((Stub)cm).setHeader(BI_BUS_NAMESPACE, BI_BUS_HEADER, (Object)header);
        }
        catch (Exception e) {
            VM.log(this.CLASS, 2, "failed to reset cm passport", e);
        }
    }

    private BiBusHeader queryServiceBibusHeader(ContentManagerService_PortType cm) throws RemoteException {
        SearchPathMultipleObject sPath = new SearchPathMultipleObject();
        sPath.set_value("~~");
        try {
            cm.query(sPath, new PropEnum[0], new Sort[0], new QueryOptions());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        BiBusHeader bibus = null;
        try {
            SOAPHeaderElement temp = ((Stub)cm).getResponseHeader(BI_BUS_NAMESPACE, BI_BUS_HEADER);
            bibus = (BiBusHeader)temp.getValueAsType(new QName(BI_BUS_NAMESPACE, BI_BUS_HEADER));
        }
        catch (Exception e) {
            throw new RemoteException("failed to getResponseHeader");
        }
        return bibus;
    }
}

