/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.mobile.c8.C8Connection;
import com.cognos.mobile.c8.factory.CognosServiceFactory;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import java.lang.ref.SoftReference;
import javax.xml.rpc.ServiceException;

public class C8ConnectionFromCredentials
extends C8Connection {
    private Class<C8ConnectionFromCredentials> CLASS = C8ConnectionFromCredentials.class;
    private String _userName;
    private String _password;
    private String _namespace;

    public C8ConnectionFromCredentials(String c8Url, String usr, String pwd, String ns) throws CMException {
        super(c8Url);
        this._userName = usr;
        this._password = pwd;
        this._namespace = ns;
    }

    @Override
    public ContentManagerService_PortType getCMService() throws CMException {
        ContentManagerService_PortType cms = null;
        if (this._cmService != null) {
            cms = (ContentManagerService_PortType)this._cmService.get();
        }
        if (cms == null) {
            try {
                cms = CognosServiceFactory.getInstance().createCMService(this.dispatcherUrl);
                this._cmService = new SoftReference<ContentManagerService_PortType>(cms);
                this.logon(cms, this._namespace, this._userName, this._password);
            }
            catch (ServiceException e) {
                this.handleServiceException(e);
            }
        }
        return cms;
    }

    private void logon(ContentManagerService_PortType cm, String namespace, String username, String password) throws CMException {
        VM.log(this.CLASS, 1, "connecting to Cognos server");
        if (namespace != null && namespace.equals("")) {
            namespace = null;
        }
        if (username != null && username.equals("")) {
            username = null;
        }
        if (password != null && password.equals("")) {
            password = null;
        }
        if (username != null) {
            StringBuffer credentialXML = new StringBuffer();
            credentialXML.append("<credential>");
            if (namespace != null) {
                credentialXML.append("<namespace>");
                credentialXML.append(namespace);
                credentialXML.append("</namespace>");
            }
            if (username != null) {
                credentialXML.append("<username>");
                credentialXML.append(username);
                credentialXML.append("</username>");
            }
            if (password != null) {
                credentialXML.append("<password>");
                credentialXML.append(password);
                credentialXML.append("</password>");
            }
            credentialXML.append("</credential>");
            XmlEncodedXML credentialXEX = new XmlEncodedXML();
            credentialXEX.set_value(credentialXML.toString());
            try {
                VM.log(this.CLASS, 1, "logging in as " + namespace + "/" + username + "...");
                cm.logon(credentialXEX, null);
            }
            catch (Exception ex) {
                String details = "failed to login as '" + username + "'";
                VM.log(this.CLASS, 3, details, ex);
                throw new CMException(1103, details, (Throwable)ex);
            }
            VM.log(this.CLASS, 1, "logged in");
        }
    }
}

