/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8CMClass;
import com.cognos.mobile.c8.C8ContentManagerCommand;
import com.cognos.mobile.common.CMException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.dom4j.Element;
import org.dom4j.QName;

public class C8ContentManagerCAMCommand
extends C8ContentManagerCommand {
    protected static final QName BUS_QUERY = new QName("query", BUS_NAMESPACE);
    private static final QName BUS_QUERYRESPONSE = new QName("queryResponse", BUS_NAMESPACE);
    private List m_resultList;
    private Element m_queryResponse = null;
    private boolean m_mimeDataEncoding = false;

    @Override
    protected void executeImpl(Element bodyElement) throws CMException {
        Element camElement = this.getRequestCAMElement();
        this.addCAMActionElement(camElement);
    }

    private void addCAMActionElement(Element camElement) {
        Element actionElement = camElement.addElement("action");
        actionElement.setText("validate");
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CMException {
        if (bodyElement == null) {
            return;
        }
        this.m_queryResponse = bodyElement.element(BUS_QUERYRESPONSE);
        if (this.m_queryResponse != null) {
            Element queryResult = this.m_queryResponse.element("queryResult");
            List classList = queryResult.elements();
            Iterator it = classList.iterator();
            this.m_resultList = new ArrayList(classList.size());
            while (it.hasNext()) {
                Element anElement = (Element)it.next();
                this.m_resultList.add(new C8CMClass(anElement));
            }
        }
    }

    public List getResultList() throws CMException {
        this.checkCommandExecuted();
        return this.m_resultList;
    }

    public boolean isResultEmpty() throws CMException {
        this.checkCommandExecuted();
        return this.m_resultList.size() == 0;
    }

    private void checkCommandExecuted() throws CMException {
        if (this.m_resultList == null) {
            throw new CMException(1162, "The Query command has not been executed");
        }
    }

    public int getResultSetSize() throws CMException {
        this.checkCommandExecuted();
        return this.m_resultList.size();
    }

    public C8CMClass getFirstResultClass() throws CMException, NoSuchElementException {
        Iterator it = this.getResultList().iterator();
        if (it.hasNext()) {
            return (C8CMClass)it.next();
        }
        throw new NoSuchElementException();
    }

    public Element getQueryResponseElement() {
        return this.m_queryResponse;
    }

    public void setMimeDataEncoding() {
        this.m_mimeDataEncoding = true;
    }
}

