/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8BIBusCommand;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.contentmanager.coordinator.ActiveCMControl;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.Tracking;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.transport.FormRequestProcessor;
import org.dom4j.Element;

public abstract class C8ContentManagerCommand
extends C8BIBusCommand {
    private boolean continueOnError = false;
    private boolean dispatcherTrustedProcess = false;

    public C8ContentManagerCommand() {
        this.setAutoRetry(false);
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        return DispatcherConnectionManager.getContentManagerConnection();
    }

    @Override
    protected String fetchRequestContext() {
        return NodeIdGuidMapper.getContentManagerNID().getPath();
    }

    public void setContinueOnError(boolean b) {
        this.continueOnError = b;
    }

    boolean isContinueOnError() {
        return this.continueOnError;
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        connection.addRequestHeader("SOAPAction", FormRequestProcessor.CONTENT_MANAGER_SERVICE);
    }

    @Override
    protected void addExtraSOAPHeaders() {
        if (this.dispatcherTrustedProcess) {
            Element cam = this.getRequestCAMElement();
            cam.addAttribute(SOAPEnvelope.XSI_NIL, "true");
            Element camProtect = this.getRequestEnvelope().getCAMProtect();
            camProtect.addElement(BIBusEnvelope.BUS_CAMPROT_SERVICEID).addText("DISP");
            this.dispatcherTrustedProcess = false;
        }
    }

    protected void addSessionRequestIds(String tag) {
        BIBusEnvelope requestEnv = this.getRequestEnvelope();
        Element trackingElement = requestEnv.getTracking();
        Tracking trackingInstance = Tracking.getInstance();
        trackingInstance.setSessionContext(trackingElement, tag + trackingInstance.getRequestIDBaseName());
        trackingInstance.setRequestContext(trackingElement);
    }

    @Override
    protected boolean checkForInactiveCM() {
        Element detailElement = this.getResponseEnvelope().getFaultDetail();
        if (detailElement == null) {
            return false;
        }
        Element errorCodeElement = (Element)detailElement.selectSingleNode("*[local-name() = 'exception']/errorCode");
        if (errorCodeElement == null) {
            return false;
        }
        String errorCodeText = errorCodeElement.getText();
        this.checkCmControl(errorCodeText);
        return "cmInStandByMode".equals(errorCodeText);
    }

    private void checkCmControl(String errorCodeText) {
        if ("cmInStandByMode".equals(errorCodeText) || "cmStoreNotAvailable".equals(errorCodeText)) {
            ActiveCMControl.getInstance().soapFaultNotify();
        }
    }
}

