/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8CMClass;
import com.cognos.mobile.c8.C8ContentManagerCommand;
import com.cognos.mobile.common.CMException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class C8ContentManagerQueryCommand
extends C8ContentManagerCommand {
    protected static final QName BUS_QUERY = new QName("query", BUS_NAMESPACE);
    private static final QName BUS_QUERYRESPONSE = new QName("queryResponse", BUS_NAMESPACE);
    private String m_queryObjectName;
    private Collection<String> m_propertyElements = new HashSet<String>();
    private LinkedHashMap<String, String> m_sortElements = new LinkedHashMap();
    private Collection<String> m_parentPropertyElements = new HashSet<String>();
    private List<C8CMClass> m_resultList;
    private Element m_queryResponse = null;
    private boolean m_mimeDataEncoding = false;
    private String m_refPropName;

    public C8ContentManagerQueryCommand(String objectName) {
        this.m_queryObjectName = objectName;
    }

    @Override
    protected void executeImpl(Element bodyElement) throws CMException {
        Element queryElement = bodyElement.addElement(BUS_QUERY);
        this.addSessionRequestIds("query");
        this.addSearchElements(queryElement);
    }

    protected void addSearchElements(Element queryElement) {
        Element searchElement = queryElement.addElement("search");
        searchElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        searchElement.setText(this.m_queryObjectName);
        Element propertiesElement = queryElement.addElement("properties");
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        int itemCount = 0;
        for (String propertyName : this.m_propertyElements) {
            Element itemElement = DocumentHelper.createElement((String)"item");
            itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
            itemElement.setText(propertyName);
            propertiesElement.add(itemElement);
            ++itemCount;
        }
        propertiesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum[" + itemCount + "]");
        Element sortByElement = queryElement.addElement("sortBy");
        sortByElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        itemCount = 0;
        for (Map.Entry<String, String> pairs : this.m_sortElements.entrySet()) {
            String propertyName = pairs.getKey();
            String sortOrder = pairs.getValue();
            Element itemElement = sortByElement.addElement("item");
            itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":sort");
            Element orderElement = itemElement.addElement("order");
            orderElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":orderEnum");
            orderElement.setText(sortOrder);
            Element propNameElement = itemElement.addElement("propName");
            propNameElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
            propNameElement.setText(propertyName);
            ++itemCount;
        }
        sortByElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":sort[" + itemCount + "]");
        Element optionsElement = queryElement.addElement("options");
        if (this.addOptions(optionsElement)) {
            optionsElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":queryOptions");
        } else {
            optionsElement.addAttribute(SOAPEnvelope.XSI_NIL, "true");
        }
    }

    private boolean addOptions(Element optionsElement) {
        boolean added = false;
        if (this.m_mimeDataEncoding) {
            Element dataEncodingElement = optionsElement.addElement("dataEncoding");
            dataEncodingElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":encodingEnum");
            dataEncodingElement.setText("MIME");
            added = true;
        }
        if (!this.m_parentPropertyElements.isEmpty()) {
            this.addRefProps(optionsElement);
            added = true;
        }
        return added;
    }

    private void addRefProps(Element optionsElement) {
        Element refPropsElement = optionsElement.addElement("refProps");
        refPropsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        Element refPropsItem = refPropsElement.addElement("item");
        refPropsItem.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":refProp");
        Element propertiesElement = refPropsItem.addElement("properties");
        propertiesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        for (String propertyName : this.m_parentPropertyElements) {
            Element itemElement = DocumentHelper.createElement((String)"item");
            itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
            itemElement.setText(propertyName);
            propertiesElement.add(itemElement);
        }
        Element refPropNameElement = refPropsItem.addElement("refPropName");
        refPropNameElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":propEnum");
        refPropNameElement.setText(this.m_refPropName);
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CMException {
        this.m_queryResponse = bodyElement.element(BUS_QUERYRESPONSE);
        Element queryResult = this.m_queryResponse.element("queryResult");
        List classList = queryResult.elements();
        Iterator it = classList.iterator();
        this.m_resultList = new ArrayList<C8CMClass>(classList.size());
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            this.m_resultList.add(new C8CMClass(anElement));
        }
    }

    public List<C8CMClass> getResultList() throws CMException {
        this.checkCommandExecuted();
        return this.m_resultList;
    }

    public void setResultList(List<C8CMClass> result) {
        this.m_resultList = result;
    }

    public boolean isResultEmpty() throws CMException {
        this.checkCommandExecuted();
        return this.m_resultList.size() == 0;
    }

    private void checkCommandExecuted() throws CMException {
        if (this.m_resultList == null) {
            throw new CMException(1162, "The Query command has not been executed");
        }
    }

    public int getResultSetSize() throws CMException {
        this.checkCommandExecuted();
        return this.m_resultList.size();
    }

    public C8CMClass getFirstResultClass() throws CMException, NoSuchElementException {
        Iterator<C8CMClass> it = this.getResultList().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        throw new NoSuchElementException();
    }

    public void setQueryObject(String objectName) {
        this.m_queryObjectName = objectName;
    }

    public String getQueryObjectName() {
        return this.m_queryObjectName;
    }

    public void addQueryPropertyName(String propertyName) {
        this.m_propertyElements.add(propertyName);
    }

    public void addSortPropertyName(String propertyName) {
        this.addSortPropertyName(propertyName, "ascending");
    }

    public void addSortPropertyName(String propertyName, String sortOrder) {
        this.m_sortElements.put(propertyName, sortOrder);
    }

    public void addQueryParentProperty(String propertyName) {
        this.m_parentPropertyElements.add(propertyName);
    }

    public void addRefPropName(String name) {
        this.m_refPropName = name;
    }

    public Element getQueryResponseElement() {
        return this.m_queryResponse;
    }

    public void setMimeDataEncoding() {
        this.m_mimeDataEncoding = true;
    }
}

