/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.developer.schemas.bibus._3.AsynchDetailUnstructuredData;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.IndexSearchServiceSpecification;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.mobile.c8.C8Connection;
import com.cognos.mobile.c8.IC8PortalTree;
import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class C8IndexSearch {
    private static Class CLASS = C8IndexSearch.class;
    private final IC8PortalTree portalTree;
    private final C8Connection c8Connection;
    private final org.dom4j.Element eUserPrefs;
    private final int maxItems;
    private Exception exception;

    public C8IndexSearch(IC8PortalTree portalTree, C8Connection c8Connection, int maxItems, org.dom4j.Element eUserPrefs) {
        this.portalTree = portalTree;
        this.c8Connection = c8Connection;
        this.maxItems = maxItems;
        this.eUserPrefs = eUserPrefs;
    }

    public C8.PortalItem[] goSearch(String keyword) {
        try {
            if (!this.isServiceAvailable()) {
                return new C8.PortalItem[0];
            }
            Vector storeIDs = this.indexSearch(keyword);
            C8.PortalItem[] items = this.queryReportsByStoreID(storeIDs);
            return items;
        }
        catch (Exception e) {
            this.exception = e;
            return new C8.PortalItem[0];
        }
    }

    public Vector indexSearch(String keyword) throws CMException, SAXException, IOException {
        Vector storeIDs = new Vector();
        Option[] options = new Option[2];
        AsynchOptionInt primaryThreshold = new AsynchOptionInt();
        AsynchOptionInt secondaryThreshold = new AsynchOptionInt();
        primaryThreshold.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryThreshold.setValue(10000);
        secondaryThreshold.setName(AsynchOptionEnum.secondaryWaitThreshold);
        secondaryThreshold.setValue(10000);
        options[0] = primaryThreshold;
        options[1] = secondaryThreshold;
        String spec = this.buildSearchQuerySpec(keyword);
        IndexSearchServiceSpecification issSpec = new IndexSearchServiceSpecification();
        issSpec.setValue(new Specification(spec));
        ParameterValue[] pv = new ParameterValue[]{};
        AsynchReply asynchReply = null;
        try {
            this.c8Connection.setUserPreferences((Remote)this.c8Connection.getIndexSearchService(), this.eUserPrefs);
            asynchReply = this.c8Connection.getIndexSearchService().runSpecification((AsynchSpecification)issSpec, pv, options);
            asynchReply = this.waitUntilComplete(asynchReply, pv, options);
            this.parseReply(asynchReply, storeIDs);
            if (asynchReply != null && asynchReply.getStatus() != AsynchReplyStatusEnum.conversationComplete) {
                this.c8Connection.getIndexSearchService().release(asynchReply.getPrimaryRequest());
            }
        }
        catch (RemoteException e) {
            throw new CMException(1152, new String[]{e.getMessage()}, (Throwable)e);
        }
        return storeIDs;
    }

    private AsynchReply waitUntilComplete(AsynchReply asynchReply, ParameterValue[] parameterValues, Option[] options) throws CMException {
        try {
            while (asynchReply.getStatus() != AsynchReplyStatusEnum.complete && asynchReply.getStatus() != AsynchReplyStatusEnum.conversationComplete) {
                asynchReply = this.c8Connection.getIndexSearchService().wait(asynchReply.getPrimaryRequest(), parameterValues, options);
            }
        }
        catch (RemoteException ex) {
            VM.log(CLASS, 3, ex);
            throw new CMException(1152, new String[]{ex.getMessage()}, (Throwable)ex);
        }
        return asynchReply;
    }

    private String buildSearchQuerySpec(String keyword) {
        String template = "<cs:document xmlns:cs=\"http://developer.cognos.com/schemas/cs/\"><cs:request><cs:searchQuery><cs:terms>#TERMS#</cs:terms><cs:requestParameters><cs:searchType>normal</cs:searchType><cs:pageSize>" + this.maxItems + "</cs:pageSize>" + "<cs:includeSearchQuery>false</cs:includeSearchQuery>" + "<cs:includeSearchConversation>true</cs:includeSearchConversation>" + "<cs:includeSecurityContext>false</cs:includeSecurityContext>" + "<cs:typeList>" + this.SupportedTypeToXML() + "</cs:typeList>" + "<cs:urlParameters>" + "<cs:urlParameter name='cs_tree'>true</cs:urlParameter>" + "<cs:urlParameter name='cs_requestversion'>2</cs:urlParameter>" + "</cs:urlParameters></cs:requestParameters>" + "</cs:searchQuery>" + "</cs:request>" + "</cs:document>";
        String str = template.replace("#TERMS#", XMLHelper.encodeXml(keyword));
        return str;
    }

    private void parseReply(AsynchReply asynchReply, Vector storeIDs) throws SAXException, IOException {
        for (int i = 0; i < asynchReply.getDetails().length; ++i) {
            if (!(asynchReply.getDetails()[i] instanceof AsynchDetailUnstructuredData)) continue;
            AsynchDetailUnstructuredData result = (AsynchDetailUnstructuredData)asynchReply.getDetails()[i];
            String decodeXML = XMLHelper.xmlDecode(result.getData().get_value());
            this.parseResult(decodeXML, storeIDs);
        }
    }

    private boolean isServiceAvailable() {
        try {
            C8.PortalItem[] items = this.portalTree.findFromCMQuery("capability/securedFunction[@name='Execute Indexed Search']");
            return items != null && items.length != 0;
        }
        catch (CMException e) {
            return false;
        }
    }

    private C8.PortalItem[] queryReportsByStoreID(Vector storeIDs) throws CMException {
        Vector<C8.PortalItem> portalItems = new Vector<C8.PortalItem>();
        for (int i = 0; i < storeIDs.size(); ++i) {
            C8.PortalItem[] report = this.portalTree.findFromCMQuery("storeID(\"" + (String)storeIDs.elementAt(i) + "\")");
            if (report.length == 0) continue;
            portalItems.addElement(this.portalTree.findItemFromCMQuery(report[0].cmPath));
        }
        return portalItems.toArray(new C8.PortalItem[portalItems.size()]);
    }

    private Vector parseResult(String output, Vector storeIDs) throws SAXException, IOException {
        DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
        Document doc = xdb.parse(new InputSource(new StringReader(output.toString())));
        NodeList items = doc.getElementsByTagName("cs:item");
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            NodeList nodes = item.getChildNodes();
            int indexID = this.getNodeIndex(nodes, "cs:id");
            int indexType = this.getNodeIndex(nodes, "cs:type");
            if (indexID == -1 || indexType == -1) continue;
            String idVal = nodes.item(indexID).getFirstChild().getNodeValue();
            String typeVal = nodes.item(indexType).getFirstChild().getNodeValue();
            if (!this.isSupportedType(typeVal) || idVal.length() == 0) continue;
            storeIDs.addElement(idVal);
        }
        return storeIDs;
    }

    int getNodeIndex(NodeList nodes, String nodeName) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!nodeName.equals(nodes.item(i).getNodeName())) continue;
            return i;
        }
        return -1;
    }

    private boolean isSupportedType(String type) {
        for (int i = 0; i < C8.C8_SUPPORTED_OBJECT_TYPE.length; ++i) {
            if (!type.equals(C8.C8_SUPPORTED_OBJECT_TYPE[i])) continue;
            return true;
        }
        return false;
    }

    private String SupportedTypeToXML() {
        StringBuffer type = new StringBuffer();
        for (int i = 0; i < C8.C8_SUPPORTED_OBJECT_TYPE.length; ++i) {
            type.append("<cs:type>");
            type.append(C8.C8_SUPPORTED_OBJECT_TYPE[i]);
            type.append("</cs:type>");
        }
        return type.toString();
    }

    public Exception getException() {
        return this.exception;
    }
}

