/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.InteractiveReport;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.RunOption;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.mobile.c8.C8CMClass;
import com.cognos.mobile.c8.ConsumerRooter;
import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.C8Helper;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;

public abstract class C8PortalItemFactory {
    private static final C8PortalItemFactory instance = new C8PortalItemFactory(){

        @Override
        public C8.PortalItem createPortalItem(BaseClass cmResult) {
            String[] r;
            NmtokenArrayProp nap;
            BaseClass[] baseClass;
            C8.PortalItem item = new C8.PortalItem();
            item.defaultName = cmResult.getDefaultName().getValue();
            item.storeID = cmResult.getStoreID().getValue().get_value();
            item.modificationTime = cmResult.getModificationTime().getValue().toString();
            if (cmResult instanceof BaseReport) {
                Option[] opts;
                OptionArrayProp oap;
                StringProp defaultDescription = ((BaseReport)cmResult).getDefaultDescription();
                if (defaultDescription != null) {
                    item.defaultDescription = defaultDescription.getValue();
                }
                if ((oap = ((BaseReport)cmResult).getOptions()) != null && (opts = oap.getValue()) != null) {
                    for (int i = 0; i < opts.length; ++i) {
                        RunOption ropt;
                        if (!(opts[i] instanceof RunOption) || (ropt = (RunOption)opts[i]).getName() != RunOptionEnum.prompt) continue;
                        RunOptionBoolean rob = (RunOptionBoolean)ropt;
                        item.prompt = rob.isValue();
                    }
                }
            }
            String baseReportClass = "Report";
            if (cmResult instanceof ReportView && (baseClass = ((ReportView)cmResult).getBase().getValue()) != null && baseClass.length > 0) {
                for (int i = 0; i < baseClass.length; ++i) {
                    BaseClass baseReport = baseClass[i];
                    if (!(baseReport instanceof InteractiveReport)) continue;
                    baseReportClass = "InteractiveReport";
                    break;
                }
            }
            if ((nap = cmResult.getPermissions()) != null && (r = nap.getValue()) != null) {
                item.permissions = r;
            }
            item.cmPath = cmResult.getSearchPath().getValue();
            item.itemType = C8Helper.crackObjectClass(cmResult.getObjectClass().getValue().getValue(), baseReportClass);
            return item;
        }

        @Override
        public C8.PortalItem createPortalItem(C8CMClass cmClass) {
            Element val;
            Element optionsEl;
            C8.PortalItem item = new C8.PortalItem();
            Element baseElement = cmClass.getItemElement().element("base");
            String baseReportClass = "Report";
            if (baseElement != null) {
                if (baseElement.element("value") == null) {
                    return null;
                }
                Iterator it2 = baseElement.element("value").elementIterator("item");
                while (it2.hasNext()) {
                    Element el = (Element)it2.next();
                    String v = el.attributeValue("type");
                    if (v == null || v.indexOf("interactiveReport") <= -1) continue;
                    baseReportClass = "InteractiveReport";
                    break;
                }
            }
            item.itemType = C8Helper.crackObjectClass(cmClass.getCMClassName(), baseReportClass);
            Element defaultNameElt = cmClass.getItemElement().element("defaultName");
            item.defaultName = defaultNameElt == null ? "<null>" : defaultNameElt.elementText("value");
            Element searchPathElt = cmClass.getItemElement().element("searchPath");
            item.cmPath = searchPathElt == null ? "<null>" : searchPathElt.elementText("value");
            Element storeIdElt = cmClass.getItemElement().element("storeID");
            item.storeID = storeIdElt.elementText("value");
            Element modTimeElt = cmClass.getItemElement().element("modificationTime");
            item.modificationTime = modTimeElt.elementText("value");
            Element defaultDescriptionElt = cmClass.getItemElement().element("defaultDescription");
            item.defaultDescription = defaultDescriptionElt == null ? "<null>" : defaultDescriptionElt.elementText("value");
            Element hiddenElt = cmClass.getItemElement().element("hidden");
            item.isHidden = hiddenElt != null && "true".equals(hiddenElt.elementText("value"));
            Element permsEl = cmClass.getItemElement().element("permissions");
            if (permsEl != null) {
                ArrayList<String> perms = new ArrayList<String>();
                Iterator it2 = permsEl.element("value").elementIterator("item");
                while (it2.hasNext()) {
                    Element el = (Element)it2.next();
                    String v = el.getText();
                    if (v == null) continue;
                    perms.add(v);
                }
                item.permissions = perms.toArray(new String[perms.size()]);
            }
            if ((optionsEl = cmClass.getItemElement().element("options")) != null && (val = optionsEl.element("value")) != null) {
                Iterator it2 = val.elementIterator("item");
                while (it2.hasNext()) {
                    Element el = (Element)it2.next();
                    if (!el.element("name").getText().equals("prompt")) continue;
                    String v = el.element("value").getText();
                    if (v.equals("true")) {
                        item.prompt = true;
                        break;
                    }
                    item.prompt = false;
                    break;
                }
            }
            item.sourcePath = ConsumerRooter.convertSearchPathToSourcePath(item.cmPath);
            return item;
        }
    };

    public static C8PortalItemFactory getInstance() {
        return instance;
    }

    public abstract C8.PortalItem createPortalItem(BaseClass var1);

    public abstract C8.PortalItem createPortalItem(C8CMClass var1);
}

