/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.BiBusEnvelopeCMQueryMachine;
import com.cognos.mobile.c8.C8Connection;
import com.cognos.mobile.c8.C8ConnectionCMQueryMachine;
import com.cognos.mobile.c8.ConsumerRooter;
import com.cognos.mobile.c8.IC8PortalTree;
import com.cognos.mobile.c8.ICMQueryMachine;
import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.standardedition.SERes;
import com.cognos.mobile.vm.VM;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public final class C8PortalTree
implements IC8PortalTree {
    private static final Class<C8PortalTree> CLASS;
    static final String KEYWORD_QUERY_TEMPLATE;
    private final ICMQueryMachine queryMachine;
    public static final String CMPATH = "cm:";
    public static final String SOURCEPATH = "source:";
    public static final String STOREID = "store:";

    public C8PortalTree(C8Connection c8Connection) throws CMException {
        C8ConnectionCMQueryMachine queryMachine = new C8ConnectionCMQueryMachine(c8Connection);
        this.queryMachine = new ConsumerRooter(queryMachine, C8PortalTree.initPublicRoot(null, queryMachine));
    }

    public static IC8PortalTree create(String consumerRoot, BIBusEnvelope biBusEnvelope) throws CMException {
        ConsumerRooter cr;
        C8.PortalItem[] root;
        BiBusEnvelopeCMQueryMachine queryMachine = new BiBusEnvelopeCMQueryMachine(biBusEnvelope);
        C8.PortalItem defaultRoot = C8PortalTree.initPublicRoot(null, queryMachine);
        if (consumerRoot != null && (root = (cr = new ConsumerRooter(queryMachine, defaultRoot)).findFromCMQuery(consumerRoot)) != null && root.length > 0) {
            return new C8PortalTree(root[0], biBusEnvelope);
        }
        return new C8PortalTree(defaultRoot, biBusEnvelope);
    }

    private C8PortalTree(C8.PortalItem consumerRoot, BIBusEnvelope biBusEnvelope) throws CMException {
        BiBusEnvelopeCMQueryMachine queryMachine = new BiBusEnvelopeCMQueryMachine(biBusEnvelope);
        this.queryMachine = new ConsumerRooter(queryMachine, C8PortalTree.initPublicRoot(consumerRoot, queryMachine));
    }

    private static C8.PortalItem initPublicRoot(C8.PortalItem consumerRoot, ICMQueryMachine queryMachine) throws CMException {
        C8.PortalItem publicRoot = consumerRoot;
        if (consumerRoot == null) {
            C8.PortalItem[] pi = queryMachine.findFromCMQuery("/content");
            pi[0].sourcePath = C8PortalTree.getPublicRootPath(pi[0].defaultName);
            publicRoot = pi[0];
        }
        return publicRoot;
    }

    public static String getPublicRootPath(String defaultName) {
        return "/" + CMUrlHelper.encodeSourcePathElement(defaultName);
    }

    public C8.PortalItem findItemFromSourcePath(String path) throws CMException {
        C8.PortalItem[] pi = this.findFromSourcePath(path);
        if (pi.length > 0) {
            return pi[0];
        }
        throw new CMException(1101, new String[]{path});
    }

    @Override
    public C8.PortalItem[] findFromSourcePath(String path) throws CMException {
        if (path.equals("/")) {
            ArrayList<C8.PortalItem> result = new ArrayList<C8.PortalItem>();
            result.addAll(Arrays.asList(this.queryMachine.findFromCMQuery("~/*")));
            result.addAll(Arrays.asList(this.queryMachine.findFromCMQuery("/content")));
            return result.toArray(new C8.PortalItem[result.size()]);
        }
        return this.queryMachine.findFromSourcePath(path);
    }

    @Override
    public C8.PortalItem findItemFromCMQuery(String cmPath) throws CMException {
        C8.PortalItem[] items = this.queryMachine.findFromCMQuery(cmPath);
        if (items.length > 0) {
            return items[0];
        }
        String details = SERes.singleton.formatString("1101", new String[]{cmPath}, Locale.getDefault());
        throw new CMException(1101, details);
    }

    @Override
    public C8.PortalItem[] findFromCMQuery(String cmQuery) throws CMException {
        return this.queryMachine.findFromCMQuery(cmQuery);
    }

    @Override
    public C8.PortalItem[] findFromKeyword(String keyword) throws CMException {
        String template = C8PortalTree.getKeywordQueryTemplate(keyword);
        if (template == null) {
            return new C8.PortalItem[0];
        }
        return this.queryMachine.findFromCMQuery(CMStringHelper.formatString(template, keyword));
    }

    static String getKeywordQueryTemplate(String keyword) {
        if (keyword == null || keyword.length() == 0 || keyword.indexOf(39) != -1 && keyword.indexOf(34) != -1) {
            return null;
        }
        String template = KEYWORD_QUERY_TEMPLATE;
        if (keyword.indexOf(39) != -1) {
            template = template.replace('\'', '\"');
        }
        return template;
    }

    @Override
    public final C8.PortalItem[] find(String path) throws CMException {
        try {
            if (path.startsWith(CMPATH)) {
                return this.findFromCMQuery(path.substring(CMPATH.length()));
            }
            if (path.startsWith(SOURCEPATH)) {
                return this.findFromSourcePath(path.substring(SOURCEPATH.length()));
            }
            if (path.startsWith(STOREID)) {
                return this.findFromCMQuery("storeID(\"" + path.substring(STOREID.length()) + "\")");
            }
        }
        catch (CMException cme) {
            if (cme.getErrorCode() == 1112) {
                throw cme;
            }
            VM.log(CLASS, 2, cme);
            return null;
        }
        C8.PortalItem[] item = null;
        try {
            item = this.findFromSourcePath(path);
        }
        catch (CMException e) {
            if (e.getErrorCode() == 1112) {
                throw e;
            }
            VM.log(CLASS, 1, "Couldn't find report as a sourcePath: " + path);
            try {
                if (item == null) {
                    item = this.findFromCMQuery(path);
                }
            }
            catch (CMException ee) {
                VM.log(CLASS, 1, "Couldn't find report as a cmPath: " + path);
                try {
                    item = this.findFromCMQuery("storeID(\"" + path + "\")");
                    if (item == null) {
                        VM.log(CLASS, 1, "Couldn't find report as a storeId: " + path);
                    }
                }
                catch (CMException eee) {
                    if (e.getErrorCode() == 1112) {
                        throw e;
                    }
                    VM.log(CLASS, 1, "Couldn't find report as a storeId: " + path);
                }
            }
        }
        if (item != null) {
            VM.log(CLASS, 0, "" + item);
        } else {
            VM.log(CLASS, 2, "Could not determine storeID for item from either the reportPath or reportSource or storeId.");
        }
        return item;
    }

    @Override
    public C8.PortalItem findItem(String storeID, String reportPath, String reportSource) throws CMException {
        C8.PortalItem item;
        block17: {
            item = null;
            if (storeID != null) {
                item = this.findItemFromCMQuery("storeID(\"" + storeID + "\")");
            } else if (reportSource != null) {
                item = this.findItemFromSourcePath(reportSource);
            } else if (reportPath != null) {
                try {
                    item = this.findItemFromSourcePath(reportPath);
                }
                catch (CMException e) {
                    if (e.getErrorCode() == 1112) {
                        throw e;
                    }
                    VM.log(CLASS, 1, "Couldn't find report as a sourcePath: " + reportPath);
                    try {
                        if (item == null) {
                            item = this.findItemFromCMQuery(reportPath);
                        }
                    }
                    catch (CMException ee) {
                        if (e.getErrorCode() == 1112) {
                            throw e;
                        }
                        VM.log(CLASS, 1, "Couldn't find report as a cmPath: " + reportPath);
                        try {
                            item = this.findItemFromCMQuery("storeID(\"" + reportPath + "\")");
                            if (item == null) {
                                VM.log(CLASS, 1, "Couldn't find report as a storeId: " + reportPath);
                            }
                        }
                        catch (CMException eee) {
                            if (e.getErrorCode() == 1112) {
                                throw e;
                            }
                            VM.log(CLASS, 1, "Couldn't find report as a storeId: " + reportPath);
                        }
                    }
                    if (item != null) break block17;
                    throw e;
                }
            }
        }
        if (item != null) {
            VM.log(CLASS, 0, "" + item);
            return item;
        }
        CMException ce = new CMException(1137, "Could not determine storeID for item from either the reportPath or reportSource.");
        VM.log(CLASS, 2, ce);
        throw ce;
    }

    @Override
    public C8.PortalItem dereferenceShortcut(C8.PortalItem item) throws CMException {
        if (55 == item.itemType) {
            C8.PortalItem[] portalItems = this.find(item.sourcePath);
            if (portalItems == null || portalItems.length != 1) {
                throw new CMException(1160, "Portal item for shortcut was not retrieved.");
            }
            item = portalItems[0];
            return this.dereferenceShortcut(item);
        }
        return item;
    }

    public ICMQueryMachine getQueryMachine() {
        return this.queryMachine;
    }

    static {
        int i;
        CLASS = C8PortalTree.class;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < C8.C8_SUPPORTED_OBJECT_TYPE.length; ++i) {
            sb.append("/content//");
            sb.append(C8.C8_SUPPORTED_OBJECT_TYPE[i]);
            sb.append("[contains(@defaultName,'{1}')][permission('execute')]");
            sb.append(" | ");
        }
        for (i = 0; i < C8.C8_SUPPORTED_OBJECT_TYPE.length; ++i) {
            sb.append("~//");
            sb.append(C8.C8_SUPPORTED_OBJECT_TYPE[i]);
            sb.append("[contains(@defaultName,'{1}')][permission('execute')]");
            if (i == C8.C8_SUPPORTED_OBJECT_TYPE.length - 1) continue;
            sb.append(" | ");
        }
        KEYWORD_QUERY_TEMPLATE = sb.toString();
    }
}

