/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.vm.VM;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.pdk.SOAPXMLSource;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;

public class C8SOAPMessageOutputter {
    private static final Class CLASS = C8SOAPMessageOutputter.class;
    private static final String CONTENT_TYPE = "Content-Type: ";
    private static final String CONTENT_LENGTH = "Content-Length: ";
    private static final String UTF8 = "utf-8";
    private static final String TEXT_XML = "text/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String MULTI_PART_RELATED_TEXT_XML = "multipart/related; type=\"text/xml\"";
    private static final String MULTI_PART_CONTENT_TYPE = "multipart/related; type=\"text/xml\"; boundary=\"";
    private static final String MULTI_PART_CONTENT_TYPE_P1 = "multipart/related; type=\"text/xml\"; start=\"";
    private static final String MULTI_PART_CONTENT_TYPE_P2 = "; boundary=\"";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE = "multipart/byteranges; boundary=";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE_P1 = "multipart/byteranges; start=";
    private static final String MULTI_PART_BYTERANGES_CONTENT_TYPE_P2 = "; boundary=";
    private static final byte[] baCONTENT_TYPE_TEXTXML = "Content-Type: text/xml; charset=utf-8\r\n".getBytes();
    private static final byte[] baCONTENTID_SP = "Content-ID: ".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();
    private SOAPXMLSource anEnvelope;
    private Iterator soapAttachments;
    private OutputStream outStream;
    private String mimeBoundary;
    private String mimeStartPartContentID = null;
    private Outputter myOutputter;
    private boolean doTrustedRequest = false;
    private String serviceID;

    public C8SOAPMessageOutputter(SOAPXMLSource envelope, Iterator attachments, OutputStream output) {
        this.anEnvelope = envelope;
        this.soapAttachments = attachments;
        this.setOutputStream(output);
        this.myOutputter = envelope == null && this.soapAttachments != null && this.soapAttachments.hasNext() ? new MultipartByterangeOutputter() : (this.soapAttachments != null && this.soapAttachments.hasNext() ? new MultipartOutputter() : new SimpleOutputter());
    }

    public void setOutputStream(OutputStream output) {
        this.outStream = output != null ? new BufferedOutputStream(output, 8192) : output;
    }

    public void write() throws IOException {
        Check.notNull((Object)this.outStream);
        try {
            this.myOutputter.write();
            this.outStream.flush();
        }
        catch (IOException ex) {
            if (this.soapAttachments != null) {
                while (this.soapAttachments.hasNext()) {
                    InputStream aStream = (InputStream)this.soapAttachments.next();
                    try {
                        aStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            throw ex;
        }
    }

    public String getContentType() {
        return this.myOutputter.getContentType();
    }

    public void setMimeBoundary(String boundary) {
        Check.notNull((Object)boundary);
        this.mimeBoundary = boundary;
    }

    public void setMimeStartPartContentID(String cid) {
        this.mimeStartPartContentID = cid;
    }

    void setDoTrustedRequest(boolean trusted, String serviceID) {
        this.doTrustedRequest = trusted;
        this.serviceID = serviceID;
    }

    public boolean canResend() {
        return this.myOutputter.canResend();
    }

    private String getMimeBoundary() {
        if (this.mimeBoundary == null) {
            this.mimeBoundary = StringUtils.getUniqueValue();
        }
        return this.mimeBoundary;
    }

    public class MultipartByterangeOutputter
    extends MultipartOutputter {
        @Override
        protected String getContentType() {
            if (C8SOAPMessageOutputter.this.mimeStartPartContentID == null) {
                return C8SOAPMessageOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE + C8SOAPMessageOutputter.this.getMimeBoundary();
            }
            return C8SOAPMessageOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE_P1 + C8SOAPMessageOutputter.this.mimeStartPartContentID + C8SOAPMessageOutputter.MULTI_PART_BYTERANGES_CONTENT_TYPE_P2 + C8SOAPMessageOutputter.this.getMimeBoundary();
        }

        @Override
        protected void writeAttachments(byte[] startMimeBoundary) throws IOException {
            byte[] buf = new byte[8192];
            int count = 0;
            while (C8SOAPMessageOutputter.this.soapAttachments.hasNext()) {
                int totalBytesRead = 0;
                if (VM.wouldLog(CLASS, 0)) {
                    VM.log(CLASS, 0, "Writing attachment number " + ++count);
                }
                InputStream is = (InputStream)C8SOAPMessageOutputter.this.soapAttachments.next();
                try {
                    C8SOAPMessageOutputter.this.outStream.write(startMimeBoundary);
                    InternetHeaders headers = new InternetHeaders(is);
                    this.removeAcrobatReaderBarfHeaders(headers);
                    Enumeration headenum = headers.getAllHeaderLines();
                    while (headenum.hasMoreElements()) {
                        String head = (String)headenum.nextElement();
                        C8SOAPMessageOutputter.this.outStream.write(head.getBytes());
                        C8SOAPMessageOutputter.this.outStream.write("\r\n".getBytes());
                    }
                    C8SOAPMessageOutputter.this.outStream.write("\r\n".getBytes());
                }
                catch (MessagingException e) {
                    VM.log(CLASS, 3, "Trouble removing headers from multipart byterange part");
                }
                catch (IOException ex) {
                    is.close();
                    throw ex;
                }
                try {
                    int iread = is.read(buf, 0, 8192);
                    while (iread > 0) {
                        C8SOAPMessageOutputter.this.outStream.write(buf, 0, iread);
                        totalBytesRead += iread;
                        iread = is.read(buf, 0, 8192);
                    }
                }
                catch (IOException ex) {
                    is.close();
                    throw ex;
                }
                if (!VM.wouldLog(CLASS, 0)) continue;
                VM.log(CLASS, 0, "Wrote attachment " + count + " of size: " + totalBytesRead);
            }
        }

        private void removeAcrobatReaderBarfHeaders(InternetHeaders headers) {
            headers.removeHeader("Content-Length");
            headers.removeHeader("Content-Transfer-Encoding");
            headers.removeHeader("Content-ID");
            headers.removeHeader("Accept-Ranges");
        }
    }

    private class MultipartOutputter
    extends Outputter {
        private MultipartOutputter() {
        }

        private void writeSOAPPart(byte[] startMimeBoundary) throws IOException, UnsupportedEncodingException {
            C8SOAPMessageOutputter.this.outStream.write(startMimeBoundary);
            C8SOAPMessageOutputter.this.outStream.write(baCONTENT_TYPE_TEXTXML);
            if (C8SOAPMessageOutputter.this.mimeStartPartContentID != null) {
                C8SOAPMessageOutputter.this.outStream.write(baCONTENTID_SP);
                C8SOAPMessageOutputter.this.outStream.write(C8SOAPMessageOutputter.this.mimeStartPartContentID.getBytes(C8SOAPMessageOutputter.UTF8));
                C8SOAPMessageOutputter.this.outStream.write(CRLF);
            }
            ByteArrayOutputStream docOut = new ByteArrayOutputStream();
            C8SOAPMessageOutputter.this.anEnvelope.writeAsXML((OutputStream)docOut);
            byte[] docBuf = docOut.toByteArray();
            if (C8SOAPMessageOutputter.this.doTrustedRequest) {
                docBuf = this.signTrustedRequest(docBuf);
            }
            String contentLengthHeader = C8SOAPMessageOutputter.CONTENT_LENGTH + Integer.toString(docBuf.length);
            C8SOAPMessageOutputter.this.outStream.write(contentLengthHeader.getBytes(C8SOAPMessageOutputter.UTF8));
            C8SOAPMessageOutputter.this.outStream.write(CRLF);
            C8SOAPMessageOutputter.this.outStream.write(CRLF);
            C8SOAPMessageOutputter.this.outStream.write(docBuf);
        }

        protected void writeAttachments(byte[] startMimeBoundary) throws IOException {
            byte[] buf = new byte[8192];
            int count = 0;
            while (C8SOAPMessageOutputter.this.soapAttachments.hasNext()) {
                int totalBytesRead = 0;
                if (VM.wouldLog(CLASS, 0)) {
                    VM.log(CLASS, 0, "Writing attachment number " + ++count);
                }
                InputStream is = (InputStream)C8SOAPMessageOutputter.this.soapAttachments.next();
                try {
                    C8SOAPMessageOutputter.this.outStream.write(startMimeBoundary);
                    int iread = is.read(buf, 0, 8192);
                    while (iread > 0) {
                        C8SOAPMessageOutputter.this.outStream.write(buf, 0, iread);
                        totalBytesRead += iread;
                        iread = is.read(buf, 0, 8192);
                    }
                }
                catch (IOException ex) {
                    is.close();
                    throw ex;
                }
                if (!VM.wouldLog(CLASS, 0)) continue;
                VM.log(CLASS, 0, "Wrote attachment " + count + " of size: " + totalBytesRead);
            }
        }

        @Override
        boolean canResend() {
            return false;
        }

        @Override
        protected void write() throws IOException {
            try {
                byte[] startMimeBoundary = ("\r\n--" + C8SOAPMessageOutputter.this.getMimeBoundary() + "\r\n").getBytes(C8SOAPMessageOutputter.UTF8);
                byte[] endMimeBoundary = ("\r\n--" + C8SOAPMessageOutputter.this.getMimeBoundary() + "--\r\n").getBytes(C8SOAPMessageOutputter.UTF8);
                if (C8SOAPMessageOutputter.this.anEnvelope != null) {
                    this.writeSOAPPart(startMimeBoundary);
                }
                this.writeAttachments(startMimeBoundary);
                C8SOAPMessageOutputter.this.outStream.write(endMimeBoundary);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
        }

        @Override
        protected String getContentType() {
            if (C8SOAPMessageOutputter.this.mimeStartPartContentID == null) {
                return C8SOAPMessageOutputter.MULTI_PART_CONTENT_TYPE + C8SOAPMessageOutputter.this.getMimeBoundary() + "\"";
            }
            return C8SOAPMessageOutputter.MULTI_PART_CONTENT_TYPE_P1 + C8SOAPMessageOutputter.this.mimeStartPartContentID + C8SOAPMessageOutputter.MULTI_PART_CONTENT_TYPE_P2 + C8SOAPMessageOutputter.this.getMimeBoundary() + "\"";
        }
    }

    private class SimpleOutputter
    extends Outputter {
        private SimpleOutputter() {
        }

        @Override
        protected void write() throws IOException {
            if (!C8SOAPMessageOutputter.this.doTrustedRequest) {
                C8SOAPMessageOutputter.this.anEnvelope.writeAsXML(C8SOAPMessageOutputter.this.outStream);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                C8SOAPMessageOutputter.this.anEnvelope.writeAsXML((OutputStream)baos);
                C8SOAPMessageOutputter.this.outStream.write(this.signTrustedRequest(baos.toByteArray()));
            }
        }

        @Override
        protected String getContentType() {
            return C8SOAPMessageOutputter.TEXT_XML_CONTENT_TYPE;
        }

        @Override
        boolean canResend() {
            return true;
        }
    }

    private abstract class Outputter {
        private Outputter() {
        }

        protected byte[] signTrustedRequest(byte[] requestBytes) throws IOException {
            try {
                return CryptoFacility.signRequest((byte[])requestBytes, (String)C8SOAPMessageOutputter.this.serviceID);
            }
            catch (Exception x) {
                VM.log(CLASS, 3, "Exception signing trusted request: ", x);
                throw new IOException("Exception signing trusted request");
            }
        }

        protected abstract void write() throws IOException;

        protected abstract String getContentType();

        boolean canResend() {
            return false;
        }
    }
}

