/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8Attachment;
import com.cognos.mobile.c8.C8ByteArrayAttachment;
import com.cognos.mobile.c8.IMultiPartStreamProvider;
import com.cognos.mobile.standardedition.InputStreamFactory;
import com.cognos.mobile.vm.VM;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class C8StreamProvider
implements IMultiPartStreamProvider {
    private static final long serialVersionUID = 1L;
    private static Class<C8StreamProvider> CLASS = C8StreamProvider.class;
    private final List<C8Attachment> contents;

    public C8StreamProvider(List<C8Attachment> contents) {
        this.contents = contents;
    }

    @Override
    public InputStream getXMLStream(String contextID) {
        for (C8ByteArrayAttachment c8ByteArrayAttachment : this.contents) {
            if (!c8ByteArrayAttachment.getContentType().startsWith("text/xml")) continue;
            try {
                if (contextID == null || !contextID.equals("cid:" + c8ByteArrayAttachment.getContentID())) continue;
                return c8ByteArrayAttachment.getInputStream();
            }
            catch (IOException e) {
                VM.log(CLASS, 3, "failed to get XML stream", e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void disposeStream(String contextId) {
        ListIterator<C8Attachment> attachmentList = this.contents.listIterator();
        while (attachmentList.hasNext()) {
            C8Attachment att = (C8Attachment)attachmentList.next();
            if (!contextId.equals("cid:" + att.getContentID())) continue;
            attachmentList.remove();
            break;
        }
    }

    @Override
    public InputStream getStream(String contextID) {
        for (C8ByteArrayAttachment c8ByteArrayAttachment : this.contents) {
            if (contextID == null || !contextID.equals("cid:" + c8ByteArrayAttachment.getContentID())) continue;
            try {
                return c8ByteArrayAttachment.getInputStream();
            }
            catch (IOException io) {
                throw new RuntimeException(io.getMessage(), io);
            }
        }
        return null;
    }

    @Override
    public InputStream getHTMLStream(String contextID) {
        for (C8ByteArrayAttachment c8ByteArrayAttachment : this.contents) {
            if (!c8ByteArrayAttachment.getContentType().startsWith("text/html")) continue;
            try {
                if (contextID == null || !contextID.equals("cid:" + c8ByteArrayAttachment.getContentID())) continue;
                return c8ByteArrayAttachment.getInputStream();
            }
            catch (IOException e) {
                VM.log(CLASS, 3, "failed to get XML stream", e);
                return null;
            }
        }
        return null;
    }

    @Override
    public InputStream getMHTStream(String contextID) {
        for (C8ByteArrayAttachment c8ByteArrayAttachment : this.contents) {
            if (!c8ByteArrayAttachment.getContentType().startsWith("application/octet-stream")) continue;
            try {
                if (contextID == null || !contextID.equals("cid:" + c8ByteArrayAttachment.getContentID())) continue;
                return c8ByteArrayAttachment.getInputStream();
            }
            catch (IOException e) {
                VM.log(CLASS, 3, "failed to get MHT stream for active report.", e);
                return null;
            }
        }
        return null;
    }

    @Override
    public InputStream getImageStream(String contentID) {
        for (C8ByteArrayAttachment c8ByteArrayAttachment : this.contents) {
            if (!c8ByteArrayAttachment.getContentType().equals("image/png") || contentID == null || !contentID.equals("cid:" + c8ByteArrayAttachment.getContentID())) continue;
            try {
                return c8ByteArrayAttachment.getInputStream();
            }
            catch (IOException e) {
                VM.log(CLASS, 3, "failed to get image stream", e);
                return null;
            }
        }
        return null;
    }

    @Override
    public int getImageCount() {
        Iterator<C8Attachment> it = this.contents.iterator();
        int count = 0;
        while (it.hasNext()) {
            C8ByteArrayAttachment att = (C8ByteArrayAttachment)it.next();
            if (!att.getContentType().equals("image/png")) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void dumpAttachments() {
        for (C8ByteArrayAttachment c8ByteArrayAttachment : this.contents) {
            System.out.println("Attachment; " + c8ByteArrayAttachment.getContentID() + " " + c8ByteArrayAttachment.getContentType());
            try {
                if (c8ByteArrayAttachment.getContentType().indexOf("text") == -1) continue;
                System.out.println(new String(InputStreamFactory.slurpStream(c8ByteArrayAttachment.getInputStream()), "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

