/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.vm.VM;
import java.net.MalformedURLException;
import java.net.URL;

public class C8UrlInformation {
    private static Class<C8UrlInformation> CLASS = C8UrlInformation.class;
    private String webcontentURL;
    private String scriptFolderName;
    private String gatewayName;

    public C8UrlInformation(String fqGatewayURL) {
        try {
            int l;
            URL url = new URL(fqGatewayURL);
            StringBuilder sb = new StringBuilder();
            sb.append(url.getProtocol()).append("://").append(url.getHost());
            int port = url.getPort();
            if (port > 0) {
                sb.append(':').append(port);
            }
            String[] terms = url.getPath().split("/");
            int skipped = 0;
            for (l = terms.length - 1; l >= 0; --l) {
                if (terms[l].length() <= 0) continue;
                if (++skipped == 1) {
                    this.gatewayName = terms[l];
                    continue;
                }
                if (skipped != 2) continue;
                this.scriptFolderName = terms[l] + "/";
                break;
            }
            for (int i = 0; i < l; ++i) {
                if (terms[i].length() <= 0) continue;
                sb.append('/').append(terms[i]);
            }
            sb.append('/');
            this.webcontentURL = sb.toString();
        }
        catch (MalformedURLException e) {
            if (fqGatewayURL == null) {
                fqGatewayURL = "<null>";
            }
            String cause = String.format("Invalid gateway URL %s passed to C8UrlInformation", fqGatewayURL);
            VM.log(CLASS, 3, cause, e);
            this.scriptFolderName = null;
            this.gatewayName = null;
            this.webcontentURL = null;
            throw new RuntimeException(cause, e);
        }
    }

    public String getWebContentURL() {
        return this.webcontentURL;
    }

    public String getScriptFolderName() {
        return this.scriptFolderName;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public String toString() {
        return "webcontentURL: \"" + this.webcontentURL + "\", scriptFolderName: \"" + this.scriptFolderName + "\", gatewayName: \"" + this.gatewayName;
    }
}

