/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.ICMQueryMachine;
import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMUrlHelper;
import java.util.LinkedList;
import java.util.regex.Matcher;

public class ConsumerRooter
implements ICMQueryMachine {
    private final ICMQueryMachine queryMachine;
    private final C8.PortalItem publicRoot;
    private final String publicFolders;
    private boolean defaultRoot;

    public ConsumerRooter(ICMQueryMachine queryMachine, C8.PortalItem publicRootItem) {
        this.queryMachine = queryMachine;
        this.publicRoot = publicRootItem;
        if (publicRootItem == null) {
            throw new NullPointerException("consumerRoot.sourcePath shouldn't be null");
        }
        if (publicRootItem.sourcePath == null) {
            throw new NullPointerException("consumerRoot.sourcePath shouldn't be null");
        }
        if (this.publicRoot.cmPath.equals("/content")) {
            this.defaultRoot = true;
        }
        String[] bits = this.publicRoot.sourcePath.split("/");
        this.publicFolders = "/" + bits[1];
    }

    public C8.PortalItem getPublicRoot() {
        return this.publicRoot;
    }

    @Override
    public C8.PortalItem[] findFromCMQuery(String cmQuery) throws CMException {
        if (!this.defaultRoot && cmQuery.equals("/content")) {
            cmQuery = this.publicRoot.cmPath;
        }
        return this.correctSourcePathAndFilter(this.queryMachine.findFromCMQuery(cmQuery));
    }

    @Override
    public C8.PortalItem[] findFromSourcePath(String path) throws CMException {
        String fullSourcePath = path;
        if (path.startsWith(this.publicFolders)) {
            fullSourcePath = this.publicRoot.sourcePath;
            String subStr = path.substring(this.publicFolders.length());
            fullSourcePath = fullSourcePath + (subStr.startsWith("/") ? subStr : "/" + subStr);
        }
        return this.correctSourcePathAndFilter(this.queryMachine.findFromSourcePath(fullSourcePath));
    }

    private C8.PortalItem[] correctSourcePathAndFilter(C8.PortalItem[] pi) throws CMException {
        LinkedList<C8.PortalItem> l = new LinkedList<C8.PortalItem>();
        for (int i = 0; i < pi.length; ++i) {
            String path;
            C8.PortalItem item = pi[i];
            String string = path = item.itemType == 55 ? item.targetCMPath : item.cmPath;
            if (!path.startsWith("/content")) {
                l.add(item);
                continue;
            }
            if (!ConsumerRooter.isDescendentCmObject(this.publicRoot.cmPath, path)) continue;
            this.populateSourcePath(item);
            l.add(item);
        }
        return l.toArray(new C8.PortalItem[l.size()]);
    }

    public static String convertSearchPathToSourcePath(String searchPath) {
        Matcher m = SOURCE_PATH_REGEX.matcher(searchPath);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String s = CMUrlHelper.encodeSourcePathElement(m.group(1));
            result.append("/" + s);
        }
        return result.toString();
    }

    public void populateSourcePath(C8.PortalItem item) {
        String path;
        String string = path = item.itemType == 55 ? item.targetCMPath : item.cmPath;
        if (path.startsWith("/content")) {
            String r;
            String sub;
            if (path.length() == 8) {
                item.sourcePath = this.publicFolders;
                return;
            }
            String fullSourcePath = this.publicFolders + ConsumerRooter.convertSearchPathToSourcePath(path);
            item.sourcePath = !this.defaultRoot ? ((sub = fullSourcePath.substring(this.publicRoot.sourcePath.length())).isEmpty() ? fullSourcePath : (r = this.publicFolders + sub)) : fullSourcePath;
        }
    }

    private static boolean isDescendentCmObject(String parentCmPath, String childCmPath) {
        return childCmPath.startsWith(parentCmPath);
    }

    public String getSourcePath() {
        return this.publicRoot.sourcePath;
    }
}

