/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8CMClass;
import com.cognos.mobile.c8.C8ContentManagerCommand;
import com.cognos.mobile.c8.C8ContentManagerLogoffCommand;
import com.cognos.mobile.c8.C8ContentManagerQueryCommand;
import com.cognos.mobile.common.CMException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class ContentManagerBridge {
    private static ContentManagerBridge s_instance;

    public static void setInstance(ContentManagerBridge bridge) {
        s_instance = bridge;
    }

    public static ContentManagerBridge getInstance() {
        if (s_instance == null) {
            s_instance = new ContentManagerBridgeImpl();
        }
        return s_instance;
    }

    public void executeCommand(C8ContentManagerCommand queryCommand) throws CMException {
        ContentManagerBridge.getInstance().executeCommandImpl(queryCommand);
    }

    protected abstract void executeCommandImpl(C8ContentManagerCommand var1) throws CMException;

    public List<String> getGroupsAndRoles(Element header) throws CMException {
        C8ContentManagerQueryCommand queryCommand = new C8ContentManagerQueryCommand("~~");
        queryCommand.addQueryPropertyName("identity");
        queryCommand.setBIBusHeader(header);
        ContentManagerBridge.getInstance().executeCommand(queryCommand);
        List<C8CMClass> resultList = queryCommand.getResultList();
        ArrayList<String> res = new ArrayList<String>();
        for (C8CMClass cmClass : resultList) {
            String type = cmClass.getCMClassName();
            if (!type.equals("cm:session")) continue;
            List pl = cmClass.getPropertyList();
            for (int i = 0; i < pl.size(); ++i) {
                if (!"identity".equals(pl.get(i))) continue;
                Element identityElement = cmClass.getPropertyAsElement("identity");
                Element value = (Element)identityElement.selectSingleNode("value");
                List children = value.elements();
                for (int childIdx = 0; childIdx < children.size(); ++childIdx) {
                    Element storeIDValue;
                    Element storeID;
                    Element child = (Element)children.get(childIdx);
                    Attribute typeAtt = child.attribute("type");
                    if (typeAtt != null && typeAtt.getValue().equals("cm:group")) {
                        storeID = (Element)child.selectSingleNode("storeID");
                        storeIDValue = (Element)storeID.elements().get(0);
                        res.add(storeIDValue.getTextTrim());
                        continue;
                    }
                    if (typeAtt == null || !typeAtt.getValue().equals("cm:role")) continue;
                    storeID = (Element)child.selectSingleNode("storeID");
                    storeIDValue = (Element)storeID.elements().get(0);
                    res.add(storeIDValue.getTextTrim());
                }
            }
        }
        return res;
    }

    public void logoff(Element header) throws CMException {
        C8ContentManagerLogoffCommand logoffCommand = new C8ContentManagerLogoffCommand();
        logoffCommand.setBIBusHeader(header);
        ContentManagerBridge.getInstance().executeCommand(logoffCommand);
    }

    static class ContentManagerBridgeImpl
    extends ContentManagerBridge {
        ContentManagerBridgeImpl() {
        }

        @Override
        protected void executeCommandImpl(C8ContentManagerCommand queryCommand) throws CMException {
            queryCommand.execute();
        }
    }
}

