/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import java.io.Serializable;
import java.util.HashMap;

public class Conversation
implements Serializable {
    private static final String NULL_VALUE = "NULL";
    private static final String STATE_DATA_KEY = ".stateData";
    private static final String SPECIFICATION_KEY = ".specification";
    private static final String PARAMETERS_KEY = ".parameters";
    private static final String OPTIONS_KEY = ".options";
    private static final String SEARCH_PATH_KEY = ".searchPath";
    private static final String OPERATION_KEY = ".operation";
    private static final long serialVersionUID = -5468735786439L;
    public AsynchRequest m_Req;
    private BiBusHeader m_Hdr;
    private HashMap properties = new HashMap();

    public Conversation(BiBusHeader hdr) {
        this.m_Hdr = hdr;
    }

    public void setHeader(BiBusHeader hdr) {
        this.m_Hdr = hdr;
    }

    public BiBusHeader getHeader() {
        return this.m_Hdr;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public static void serializeAsyncRequest(Conversation conv, AsynchRequest req, String key) {
        if (req == null) {
            conv.setProperty(key, NULL_VALUE);
            return;
        }
        conv.setProperty(key + OPERATION_KEY, req.getName());
        conv.setProperty(key + SEARCH_PATH_KEY, req.getObjectPath());
        conv.setProperty(key + OPTIONS_KEY, req.getOptions());
        conv.setProperty(key + PARAMETERS_KEY, req.getParameters());
        conv.setProperty(key + SPECIFICATION_KEY, req.getSpecification());
        conv.setProperty(key + STATE_DATA_KEY, req.getStateData());
        conv.removeProperty(key);
    }

    public static AsynchRequest deserializeAsyncRequest(Conversation conv, String key) {
        String nullValue = (String)conv.getProperty(key);
        if (null != nullValue) {
            return null;
        }
        AsynchRequest req = new AsynchRequest();
        req.setName((String)conv.getProperty(key + OPERATION_KEY));
        req.setObjectPath((SearchPathSingleObject)conv.getProperty(key + SEARCH_PATH_KEY));
        req.setOptions((Option[])conv.getProperty(key + OPTIONS_KEY));
        req.setParameters((ParameterValue[])conv.getProperty(key + PARAMETERS_KEY));
        req.setSpecification((AsynchSpecification[])conv.getProperty(key + SPECIFICATION_KEY));
        req.setStateData((XmlEncodedXML)conv.getProperty(key + STATE_DATA_KEY));
        return req;
    }
}

