/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.database.RenderManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class OutputTypeManager {
    private static OutputTypeManager S_INSTANCE;
    public static boolean ENABLE_ACTIVE_REPORTS_FOR_WEB_APP;
    private HashMap<String, Boolean> m_fidelityEnabled = new HashMap();
    private static boolean bARFidelity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputTypeManager getInstance() {
        if (S_INSTANCE != null) {
            return S_INSTANCE;
        }
        Class<OutputTypeManager> clazz = OutputTypeManager.class;
        synchronized (OutputTypeManager.class) {
            if (S_INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return S_INSTANCE;
            }
            S_INSTANCE = new OutputTypeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return S_INSTANCE;
        }
    }

    private OutputTypeManager() {
        this.m_fidelityEnabled.put("IOS", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFidelityPlatforms(StringTokenizer platforms) {
        HashMap<String, Boolean> hashMap = this.m_fidelityEnabled;
        synchronized (hashMap) {
            this.m_fidelityEnabled.clear();
            while (platforms.hasMoreElements()) {
                String platform = platforms.nextToken();
                OutputTypeManager.getInstance().setFidelityEnabled(platform.trim(), true);
            }
        }
    }

    public void setARDrillFidelity(boolean bEnabled) {
        bARFidelity = bEnabled;
    }

    public void setFidelityEnabled(String platform, boolean enabled) {
        if (platform == null) {
            platform = "WEBAPP";
        }
        this.m_fidelityEnabled.put(platform, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFidelityEnabled(String platform, int portalItemType) {
        if (portalItemType == 56) {
            return false;
        }
        if (!(portalItemType != 57 && portalItemType != 65 || bARFidelity)) {
            return false;
        }
        if (platform == null) {
            platform = "WEBAPP";
        }
        Boolean res = null;
        HashMap<String, Boolean> hashMap = this.m_fidelityEnabled;
        synchronized (hashMap) {
            res = this.m_fidelityEnabled.get(platform);
        }
        if (res == null) {
            return false;
        }
        return res;
    }

    public List<Integer> getSupportedOutputFormatsForPlatform(String platformID) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if ("IOS".equals(platformID)) {
            res.add(RenderManager.PageOutputType.CCSHTMLI.getMask());
            if (this.isFidelityEnabled("IOS", 50)) {
                res.add(RenderManager.PageOutputType.VIEWERHTML.getMask());
            }
            res.add(RenderManager.PageOutputType.ACTIVEREPORTHTML.getMask());
            res.add(RenderManager.PageOutputType.CWLIVEREPORT.getMask());
        } else if (platformID != null) {
            res.add(RenderManager.PageOutputType.DB.getMask());
        } else {
            if (this.isFidelityEnabled(null, 50)) {
                res.add(RenderManager.PageOutputType.VIEWERHTML.getMask());
            }
            res.add(RenderManager.PageOutputType.CCSHTML.getMask());
            if (ENABLE_ACTIVE_REPORTS_FOR_WEB_APP) {
                res.add(RenderManager.PageOutputType.ACTIVEREPORTHTML.getMask());
            }
        }
        return res;
    }

    public int getGeneratedPageOutputTypeForPlatform(String platformID, int portalItemType, boolean forceCMS) {
        int mask = 0;
        if ("IOS".equals(platformID)) {
            mask = this.isFidelityEnabled("IOS", portalItemType) && portalItemType != 56 && !forceCMS ? (mask |= RenderManager.PageOutputType.VIEWERHTML.getMask()) : (mask |= RenderManager.PageOutputType.CCSHTMLI.getMask());
        } else if (platformID != null) {
            mask |= RenderManager.PageOutputType.DB.getMask();
        } else if (portalItemType == 57 && ENABLE_ACTIVE_REPORTS_FOR_WEB_APP) {
            mask = RenderManager.PageOutputType.ACTIVEREPORTHTML.getMask();
        } else {
            mask = this.isFidelityEnabled(null, portalItemType) && !forceCMS ? (mask |= RenderManager.PageOutputType.VIEWERHTML.getMask()) : (mask |= RenderManager.PageOutputType.DB.getMask());
            mask |= RenderManager.PageOutputType.CCSHTML.getMask();
        }
        return mask;
    }

    public int getOutputTypesForScheduled() {
        int res = RenderManager.PageOutputType.CCSHTML.getMask() | RenderManager.PageOutputType.CCSHTMLI.getMask() | RenderManager.PageOutputType.DB.getMask();
        if (this.isFidelityEnabled(null, 50) || this.isFidelityEnabled("IOS", 50)) {
            res |= RenderManager.PageOutputType.VIEWERHTML.getMask();
        }
        return res;
    }

    public int getOutputTypeMask(RenderManager.PageOutputType ... types) {
        int mask = 0;
        for (RenderManager.PageOutputType type : types) {
            mask |= type.getMask();
        }
        return mask;
    }

    public int getOutputTypesForUnspecified() {
        return RenderManager.PageOutputType.CCSHTML.getMask() | RenderManager.PageOutputType.CCSHTMLI.getMask() | RenderManager.PageOutputType.DB.getMask();
    }

    public boolean isOutputEnabled(int outputTypeMask, RenderManager.PageOutputType outputType) {
        return (outputTypeMask & outputType.getMask()) == outputType.getMask();
    }

    public int replaceOutputType(int outputTypeMask, RenderManager.PageOutputType replace, RenderManager.PageOutputType ... with) {
        outputTypeMask &= ~replace.getMask();
        for (RenderManager.PageOutputType addMask : with) {
            outputTypeMask |= addMask.getMask();
        }
        return outputTypeMask;
    }

    public List<Integer> getAllOutputFormats() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        res.add(18);
        res.add(4);
        res.add(19);
        res.add(17);
        res.add(3);
        return res;
    }

    static {
        ENABLE_ACTIVE_REPORTS_FOR_WEB_APP = true;
        bARFidelity = false;
    }
}

