/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8CMClass;
import com.cognos.mobile.c8.C8ContentManagerMultipleQueryCommand;
import com.cognos.mobile.c8.C8ContentManagerQueryCommand;
import com.cognos.mobile.c8.SavedOutput;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.LocaleHelper;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.xml.XMLHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class ReportOutput {
    private static final Class CLASS = ReportOutput.class;
    private static final String KEYWORD_QUERY_TEMPLATE = "storeID('{1}')//output[permission('read') and (@format='XHTML' or @format='HTML' or @format='PDF' or @format='CSV' or @format='XLWA' or @format='spreadsheetML')]";
    private final String reportStoreID;
    private final LinkedHashMap<String, SavedOutput> savedOutputs;

    public ReportOutput(String reportStoreID) {
        this.reportStoreID = reportStoreID;
        this.savedOutputs = new LinkedHashMap();
    }

    public void buildSavedOutputs(BIBusEnvelope biBusEnvelope, String defaultLocale) throws CMException {
        String type;
        C8ContentManagerMultipleQueryCommand mqc = new C8ContentManagerMultipleQueryCommand();
        mqc.setBIBusHeader(biBusEnvelope.getBIBusHeader().createCopy());
        C8ContentManagerQueryCommand cmqc = new C8ContentManagerQueryCommand("~");
        cmqc.addQueryPropertyName("contentLocale");
        mqc.addQuery(cmqc);
        String cmQuery = CMStringHelper.formatString(KEYWORD_QUERY_TEMPLATE, this.reportStoreID);
        C8ContentManagerQueryCommand cmqc2 = new C8ContentManagerQueryCommand(cmQuery);
        cmqc2.addQueryPropertyName("format");
        cmqc2.addQueryPropertyName("storeID");
        cmqc2.addQueryPropertyName("locale");
        cmqc2.addQueryPropertyName("objectClass");
        cmqc2.addQueryPropertyName("creationTime");
        cmqc2.addQueryPropertyName("burstKey");
        cmqc2.addQueryPropertyName("searchPath");
        cmqc2.addQueryPropertyName("ancestors");
        cmqc2.addSortPropertyName("creationTime", "descending");
        mqc.addQuery(cmqc2);
        try {
            mqc.execute();
        }
        catch (CMException e) {
            VM.log(CLASS, 3, "query \"" + cmQuery + "\" failed: " + e.toString());
            throw e;
        }
        catch (Exception e) {
            String details = "query \"" + cmQuery + "\" failed: " + e.toString();
            VM.log(CLASS, 3, details);
            throw new CMException(1105, details);
        }
        List<C8CMClass> resultList = mqc.getResultList();
        String contentLocale = null;
        for (C8CMClass cmClass : resultList) {
            type = cmClass.getCMClassName();
            if (!type.equals("cm:account")) continue;
            contentLocale = cmClass.getValue("contentLocale", null);
            break;
        }
        if (contentLocale == null) {
            contentLocale = defaultLocale;
            VM.log(CLASS, 0, "Saved output locale (Using Server locale): " + contentLocale);
        }
        for (C8CMClass cmClass : resultList) {
            type = cmClass.getCMClassName();
            if (!type.equals("cm:output")) continue;
            this.addSavedOutput(SavedOutput.createSavedOutput(cmClass), contentLocale, defaultLocale);
        }
    }

    public void addSavedOutput(SavedOutput newSavedOutput, String contentLocale, String serverLocale) {
        LocaleHelper.LocaleMatch lmNew = newSavedOutput.compareLocale(contentLocale);
        LocaleHelper.LocaleMatch lmNewServerLocale = newSavedOutput.compareLocale(serverLocale);
        SavedOutput soCur = this.savedOutputs.get(newSavedOutput.getFormat() + newSavedOutput.getBurstValue());
        if (soCur == null) {
            if (lmNew.compareTo(LocaleHelper.LocaleMatch.NONE) > 0 || lmNewServerLocale.compareTo(LocaleHelper.LocaleMatch.NONE) > 0) {
                this.savedOutputs.put(newSavedOutput.getFormat() + newSavedOutput.getBurstValue(), newSavedOutput);
            }
        } else {
            LocaleHelper.LocaleMatch lmCur = soCur.compareLocale(contentLocale);
            if (lmNew.compareTo(lmCur) > 0) {
                this.savedOutputs.put(newSavedOutput.getFormat() + newSavedOutput.getBurstValue(), newSavedOutput);
            } else if (lmNew.compareTo(lmCur) == 0 && newSavedOutput.isNewer(soCur) && (lmNew.compareTo(LocaleHelper.LocaleMatch.NONE) > 0 || lmNewServerLocale.compareTo(LocaleHelper.LocaleMatch.NONE) > 0)) {
                this.savedOutputs.put(newSavedOutput.getFormat() + newSavedOutput.getBurstValue(), newSavedOutput);
            }
        }
    }

    public void renderToXML(StringBuffer result) {
        if (!this.savedOutputs.isEmpty()) {
            result.append(XMLHelper.openTag("outputs"));
            Collection<SavedOutput> c = this.savedOutputs.values();
            Iterator<SavedOutput> iterator = c.iterator();
            while (iterator.hasNext()) {
                iterator.next().renderAsXML(result);
            }
            result.append(XMLHelper.closeTag("outputs"));
        }
    }

    public LinkedHashMap<String, SavedOutput> getSavedOutputs() {
        return this.savedOutputs;
    }
}

