/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.ReportOutput;
import com.cognos.mobile.common.C8;
import com.cognos.mobile.common.CMException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ReportOutputManager {
    private final BIBusEnvelope biBusEnvelope;
    private final String defaultLocale;
    private final HashMap<String, ReportOutput> roMap;

    public ReportOutputManager(BIBusEnvelope biBusEnvelope, String defaultLocale) {
        this.biBusEnvelope = biBusEnvelope;
        this.defaultLocale = defaultLocale;
        this.roMap = new HashMap();
    }

    public void buildReportOutputs(C8.PortalItem[] items) throws CMException {
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                List<String> permissions;
                C8.PortalItem pi = items[i];
                if (pi.permissions == null || !(permissions = Arrays.asList(pi.permissions)).contains("read") || !permissions.contains("traverse")) continue;
                switch (pi.itemType) {
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 65: {
                        ReportOutput roTemp = new ReportOutput(pi.storeID);
                        roTemp.buildSavedOutputs(this.biBusEnvelope, this.defaultLocale);
                        this.roMap.put(pi.storeID, roTemp);
                    }
                }
            }
        }
    }

    public String renderToXML(String storeID) {
        StringBuffer result = new StringBuffer();
        ReportOutput ro = this.roMap.get(storeID);
        if (ro != null) {
            ro.renderToXML(result);
        }
        return result.toString();
    }
}

