/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8;

import com.cognos.mobile.c8.C8CMClass;
import com.cognos.mobile.common.C8Helper;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper2;
import com.cognos.mobile.common.LocaleHelper;
import com.cognos.mobile.model.data.SavedOutputType;
import com.cognos.mobile.standardedition.DOM4JUtil;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.dom4j.Element;

public class SavedOutput {
    private SavedOutputType savedOutputType;
    private String storeID;
    private String locale;
    private Date creationTime;
    private InputStream inputStream;
    private String burstValue;
    private String searchPath;
    private String parentID;
    private String parentSearchPath;

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public void setParentSearchPath(String parentSearchPath) {
        this.parentSearchPath = parentSearchPath;
    }

    public void setSavedOutputType(SavedOutputType type) {
        this.savedOutputType = type;
    }

    public static SavedOutput createSavedOutput(C8CMClass cmClass) throws CMException {
        SavedOutput reportOutput = new SavedOutput();
        reportOutput.savedOutputType = SavedOutputType.parse(cmClass.getValue("format", "<null>"));
        reportOutput.storeID = cmClass.getValue("storeID", "<null>");
        String creationDate = cmClass.getValue("creationTime", "<null>");
        Locale timeStampLocale = new Locale("en", "US", "POSIX");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timeStampLocale);
        sdf.setTimeZone(TimeZone.getTimeZone("Zulu"));
        reportOutput.burstValue = cmClass.getValue("burstKey", "<null>");
        reportOutput.searchPath = cmClass.getValue("searchPath", "<null>");
        SavedOutput.getParentID(cmClass, reportOutput);
        SavedOutput.getParentSearchPath(cmClass, reportOutput);
        try {
            reportOutput.creationTime = sdf.parse(creationDate);
        }
        catch (ParseException e) {
            throw new CMException(1106, (Throwable)e);
        }
        reportOutput.locale = cmClass.getValue("locale", "<null>");
        return reportOutput;
    }

    private static List<String> getElementsFromAncestors(C8CMClass cmClass, SavedOutput reportOutput, String elementType) {
        ArrayList<String> ancestorElements = new ArrayList<String>();
        try {
            Element ancestorsEl = cmClass.getItemElement().element("ancestors");
            if (ancestorsEl != null) {
                Iterator it = ancestorsEl.element("value").elementIterator("item");
                while (it.hasNext()) {
                    Element storeIdEl;
                    String v;
                    Element objectClassEl;
                    String cmClassObject;
                    Element el = (Element)it.next();
                    if (el == null || C8Helper.crackObjectClass(cmClassObject = (objectClassEl = el.element("objectClass")).getText(), null) == 50 || C8Helper.crackObjectClass(cmClassObject, null) == 58 || (v = (storeIdEl = el.element(elementType)).getText()) == null) continue;
                    ancestorElements.add(v);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ancestorElements;
    }

    private static void getParentSearchPath(C8CMClass cmClass, SavedOutput reportOutput) {
        String elementType = "searchPath";
        List<String> ancestorElements = SavedOutput.getElementsFromAncestors(cmClass, reportOutput, elementType);
        if (ancestorElements.size() != 0) {
            reportOutput.setParentSearchPath(ancestorElements.get(ancestorElements.size() - 1));
        }
    }

    private static void getParentID(C8CMClass cmClass, SavedOutput reportOutput) {
        String elementType = "storeID";
        List<String> ancestorElements = SavedOutput.getElementsFromAncestors(cmClass, reportOutput, elementType);
        if (ancestorElements.size() != 0) {
            reportOutput.setParentID(ancestorElements.get(ancestorElements.size() - 1));
        }
    }

    public void renderAsXML(StringBuffer result) {
        Element eOutput = DOM4JUtil.df.createElement("output");
        DOM4JUtil.addAttribute(eOutput, "savedOutputType", this.getFormat());
        DOM4JUtil.addAttribute(eOutput, "storeId", this.storeID);
        DOM4JUtil.addAttribute(eOutput, "creationTime", CMStringHelper2.formatDateTime(this.creationTime));
        DOM4JUtil.addAttribute(eOutput, "cmPath", this.parentSearchPath);
        if (!this.burstValue.equals("<null>")) {
            DOM4JUtil.addAttribute(eOutput, "burstValue", this.burstValue);
        }
        if (this.parentID != null) {
            DOM4JUtil.addAttribute(eOutput, "promptId", this.parentID);
        }
        result.append(DOM4JUtil.prettyPrint(eOutput));
    }

    public String getSearchPath() {
        return this.searchPath;
    }

    public String getStoreID() {
        return this.storeID;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getFormat() {
        return this.savedOutputType.toString();
    }

    public String getExt() {
        return this.savedOutputType.getExt();
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean isNewer(SavedOutput savedOutput) {
        return this.creationTime.compareTo(savedOutput.creationTime) > 0;
    }

    public LocaleHelper.LocaleMatch compareLocale(String locale) {
        return LocaleHelper.compareLocale(this.locale, locale);
    }

    public String getBurstValue() {
        return this.burstValue;
    }

    public String getParentID() {
        return this.parentID;
    }

    public String getParentSearchPath() {
        return this.parentSearchPath;
    }
}

