/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8.event;

import java.util.Calendar;
import java.util.Comparator;
import java.util.List;

public class C8Event {
    private final String eventID;
    private final String reportSearchPath;
    private final String defaultName;
    private final Calendar eventStartTime;
    private final List recipients;
    private final String storeID;

    public C8Event(String eventID, String defaultName, String reportSearchPath, String storeID, Calendar startTime, List recipients) {
        this.eventID = eventID;
        this.defaultName = defaultName;
        this.reportSearchPath = reportSearchPath;
        this.storeID = storeID;
        this.eventStartTime = startTime;
        this.recipients = recipients;
    }

    public String getEventID() {
        return this.eventID;
    }

    public String getStoreID() {
        return this.storeID;
    }

    public String getReportSearchPath() {
        return this.reportSearchPath;
    }

    public Calendar getStartTime() {
        return this.eventStartTime;
    }

    public List getRecipients() {
        return this.recipients;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public static abstract class C8EventComparator
    implements Comparator {
        private final int identifier;
        public static C8EventComparator NAME_ASCENDING = new C8EventComparator(1){

            public int compare(Object lhsO, Object rhsO) {
                if (lhsO instanceof C8Event && rhsO instanceof C8Event) {
                    C8Event lhs = (C8Event)lhsO;
                    C8Event rhs = (C8Event)rhsO;
                    if (lhs.reportSearchPath == null) {
                        if (rhs.reportSearchPath == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (rhs.reportSearchPath == null) {
                        return 1;
                    }
                    int ret = lhs.reportSearchPath.compareTo(rhs.reportSearchPath);
                    if (ret == 0) {
                        return C8EventComparator.longCompare(lhs.eventStartTime.getTimeInMillis(), rhs.eventStartTime.getTimeInMillis());
                    }
                    return ret;
                }
                return 0;
            }
        };
        public static C8EventComparator DATE_ASCENDING = new C8EventComparator(2){

            public int compare(Object lhsO, Object rhsO) {
                if (lhsO instanceof C8Event && rhsO instanceof C8Event) {
                    C8Event lhs = (C8Event)lhsO;
                    C8Event rhs = (C8Event)rhsO;
                    if (lhs.eventStartTime == null) {
                        if (rhs.eventStartTime == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (rhs.eventStartTime == null) {
                        return -1;
                    }
                    if (lhs.eventStartTime.getTimeInMillis() < rhs.eventStartTime.getTimeInMillis()) {
                        return -1;
                    }
                    if (lhs.eventStartTime.getTimeInMillis() > rhs.eventStartTime.getTimeInMillis()) {
                        return 1;
                    }
                    return lhs.reportSearchPath.compareTo(rhs.reportSearchPath);
                }
                return 0;
            }
        };
        public static C8EventComparator DATE_DESCENDING = new C8EventComparator(2){

            public int compare(Object lhsO, Object rhsO) {
                if (lhsO instanceof C8Event && rhsO instanceof C8Event) {
                    C8Event lhs = (C8Event)lhsO;
                    C8Event rhs = (C8Event)rhsO;
                    if (lhs.eventStartTime == null) {
                        if (rhs.eventStartTime == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (rhs.eventStartTime == null) {
                        return 1;
                    }
                    if (lhs.eventStartTime.getTimeInMillis() < rhs.eventStartTime.getTimeInMillis()) {
                        return 1;
                    }
                    if (lhs.eventStartTime.getTimeInMillis() > rhs.eventStartTime.getTimeInMillis()) {
                        return -1;
                    }
                    return lhs.reportSearchPath.compareTo(rhs.reportSearchPath);
                }
                return 0;
            }
        };

        private C8EventComparator(int identifier) {
            this.identifier = identifier;
        }

        public int getIdentifier() {
            return this.identifier;
        }

        public static C8EventComparator fromIdentifier(int identifier) {
            switch (identifier) {
                case 1: {
                    return NAME_ASCENDING;
                }
                case 2: {
                    return DATE_DESCENDING;
                }
                case 3: {
                    return DATE_ASCENDING;
                }
            }
            return null;
        }

        private static int longCompare(long lhs, long rhs) {
            if (lhs < rhs) {
                return -1;
            }
            if (lhs > rhs) {
                return 1;
            }
            return 0;
        }
    }
}

