/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8.event;

import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.status.IStatusProvider;
import com.cognos.mobile.vm.VM;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class C8EventManager
implements IStatusProvider {
    private static final Class CLASS = C8EventManager.class;
    private HashMap tracedEventsMap = new HashMap();
    private Object lock = new Object();
    private int updateFreqMins;
    private long lastUpdateTime = 0L;
    public static final int STATUS_IN_PROGRESS = 0;
    public static final int STATUS_READY = 1;
    public static final int STATUS_NOT_FOUND = 2;

    private String toString(int status) {
        String str;
        switch (status) {
            case 0: {
                str = "IN_PROGRESS";
                break;
            }
            case 1: {
                str = "READY";
                break;
            }
            default: {
                str = "NOT_FOUND";
            }
        }
        return str;
    }

    public synchronized int getEventStatus(String eventID) {
        TracedEventEntry entry = (TracedEventEntry)this.tracedEventsMap.get(eventID);
        if (entry == null) {
            return 2;
        }
        return entry.status;
    }

    public synchronized void updateEventStatus(String eventID, int status) {
        int origStatus = 2;
        TracedEventEntry entry = (TracedEventEntry)this.tracedEventsMap.get(eventID);
        if (entry == null) {
            entry = new TracedEventEntry(eventID, Calendar.getInstance(), status);
        } else {
            origStatus = entry.status;
            entry.status = status;
        }
        this.tracedEventsMap.put(eventID, entry);
        VM.log(CLASS, 0, "updated event " + eventID + " from: " + this.toString(origStatus) + " to: " + this.toString(status));
    }

    public C8EventManager(int updateFreqMins, int maxLateScheduleMins) {
        this.updateFreqMins = updateFreqMins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus() {
        StringBuffer sb = new StringBuffer();
        Object object = this.lock;
        synchronized (object) {
            sb.append("<recipients>");
            sb.append("<lastUpdateTime>");
            sb.append(CMStringHelper.formatDateTime(new Date(this.lastUpdateTime)));
            sb.append("</lastUpdateTime>");
            sb.append("<nextUpdateTime>");
            Date dt = new Date(this.lastUpdateTime + (long)(this.updateFreqMins * 60 * 1000));
            sb.append(CMStringHelper.formatDateTime(dt));
            sb.append("</nextUpdateTime>");
        }
        sb.append("</recipients>");
        return sb.toString();
    }

    class TracedEventEntry {
        String eventID;
        Calendar traceStartTime;
        int status;

        TracedEventEntry(String eventID, Calendar traceStartTime, int status) {
            this.eventID = eventID;
            this.traceStartTime = traceStartTime;
            this.status = status;
        }
    }
}

