/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8.factory;

import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.ReportService_ServiceLocator;
import com.cognos.mobile.c8.perflog.TimedCMService;
import com.cognos.mobile.c8.perflog.TimedReportService;
import java.net.URL;
import javax.xml.rpc.ServiceException;

public abstract class CognosServiceFactory {
    private static final CognosServiceFactory instance = new CognosServiceFactory(){

        @Override
        public ContentManagerService_PortType createCMService(URL url) throws ServiceException {
            ContentManagerService_PortType service = new ContentManagerService_ServiceLocator().getcontentManagerService(url);
            if (TimedCMService.isLoggerEnabled()) {
                service = new TimedCMService(service);
            }
            return service;
        }

        @Override
        public ReportService_PortType createReportService(URL url) throws ServiceException {
            ReportService_PortType service = new ReportService_ServiceLocator().getreportService(url);
            if (TimedReportService.isLoggerEnabled()) {
                service = new TimedReportService(service);
            }
            return service;
        }
    };

    public static CognosServiceFactory getInstance() {
        return instance;
    }

    public abstract ContentManagerService_PortType createCMService(URL var1) throws ServiceException;

    public abstract ReportService_PortType createReportService(URL var1) throws ServiceException;
}

