/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.c8.perflog;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.util.PerfLogger;
import java.util.concurrent.ConcurrentHashMap;

public class PerfLoggerFactory {
    ConcurrentHashMap<Long, PerThreadStuff> perThreadMap = new ConcurrentHashMap();
    private static PerfLoggerFactory instance = null;

    private static synchronized void initialize() {
        if (instance == null) {
            instance = new PerfLoggerFactory();
        }
    }

    public static void terminate() {
        instance = null;
    }

    public static PerfLoggerFactory getInstance() {
        if (instance == null) {
            PerfLoggerFactory.initialize();
        }
        return instance;
    }

    public void setupRequestThread(BIBusEnvelope env) {
        String requestId = env.getRequestContext();
        String sessionId = env.getSessionContext();
        this.perThreadMap.put(Thread.currentThread().getId(), new PerThreadStuff(requestId, sessionId));
    }

    public void cleanRequestThread() {
        PerThreadStuff pts = this.perThreadMap.get(Thread.currentThread().getId());
        if (pts != null) {
            pts.requestId = null;
            pts.sessionId = null;
        }
    }

    public PerfLogger makeLogger(String name, Class<?> clazz) {
        PerThreadStuff pts = this.perThreadMap.get(Thread.currentThread().getId());
        if (pts != null) {
            return new MobPerfLogger(name, clazz, pts.requestId, pts.sessionId);
        }
        return new MobPerfLogger(name, clazz, null, null);
    }

    public boolean isLoggerEnabled(PerfLogger.Level level, String loggerName) {
        return new PerfLogger(loggerName, this.getClass()).isPerfLevelEnabled(level);
    }

    static class MobPerfLogger
    extends PerfLogger {
        public MobPerfLogger(String loggerName, Class<?> classObj, String requestId, String sessionId) {
            super(loggerName, classObj);
            this.requestId = String.valueOf(requestId);
            this.sessionId = String.valueOf(sessionId);
        }

        String getRequestID() {
            return this.requestId;
        }

        String getSessionID() {
            return this.sessionId;
        }
    }

    static class PerThreadStuff {
        String requestId;
        String sessionId;

        public PerThreadStuff(String requestId, String sessionId) {
            this.requestId = requestId;
            this.sessionId = sessionId;
        }
    }
}

