/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.cam;

import com.cognos.mobile.cam.CCLWeb64;
import java.io.UnsupportedEncodingException;

public final class CAMCookie {
    public static final String DELIMITER = ";";
    protected static final String FLAG_SET = "1";
    protected static final String FLAG_NOT_SET = "0";
    private static final int PID_HEADER_SIZE = 4;
    private static final int PID_HEADER_NAMESPACES_CONFIGURED_FLAG_START = 0;
    private static final int PID_HEADER_NAMESPACES_CONFIGURED_FLAG_END = 1;
    private static final int PID_HEADER_ANONYMOUS_CONFIGURED_FLAG_START = 1;
    private static final int PID_HEADER_ANONYMOUS_CONFIGURED_FLAG_END = 2;
    private static final int PID_HEADER_NAMED_USER_FLAG_START = 2;
    private static final int PID_HEADER_NAMED_USER_FLAG_END = 3;
    private static final int COOKIE_VERSION_POSITION = 0;
    private static final int COOKIE_PASSPORT_ID_POSITION = 1;
    private static final int COOKIE_LOGGING_ENABLED_POSITION = 2;
    private static final int COOKIE_PASSPORT_GENERATION_POSITION = 3;
    private static final int COOKIE_CAN_CALL_LOGON_POSITION = 4;
    private String passportID = null;
    private int version = 0;
    private String action = null;
    private boolean loggingEnabled = true;
    private int generation = 0;
    private boolean canUserLogon = true;

    public CAMCookie(String theCookieValue) {
        if (theCookieValue == null || theCookieValue.length() <= 4) {
            return;
        }
        int startPos = 0;
        if (theCookieValue.charAt(3) == ':') {
            this.passportID = theCookieValue;
            this.generation = 1;
        } else {
            String decodedCookieValue;
            String substring = null;
            int elementNumber = 0;
            try {
                byte[] decodedCookieBytes = CCLWeb64.decode(theCookieValue);
                decodedCookieValue = new String(decodedCookieBytes, "UTF-8");
            }
            catch (IllegalArgumentException e) {
                decodedCookieValue = "";
            }
            catch (UnsupportedEncodingException e) {
                decodedCookieValue = "";
            }
            int tokenLocation = decodedCookieValue.indexOf(DELIMITER, startPos);
            while (tokenLocation != -1 && startPos < decodedCookieValue.length()) {
                tokenLocation = decodedCookieValue.indexOf(DELIMITER, startPos);
                substring = decodedCookieValue.substring(startPos, tokenLocation);
                startPos = tokenLocation + DELIMITER.length();
                switch (elementNumber) {
                    case 0: {
                        this.version = Integer.valueOf(substring);
                        break;
                    }
                    case 1: {
                        this.passportID = substring;
                        break;
                    }
                    case 2: {
                        this.loggingEnabled = substring.equals(FLAG_SET);
                        break;
                    }
                    case 3: {
                        this.generation = Integer.valueOf(substring);
                        break;
                    }
                    case 4: {
                        this.canUserLogon = substring.equals(FLAG_SET);
                        break;
                    }
                }
                ++elementNumber;
            }
            this.action = null;
        }
    }

    public boolean areCamNamespacesConfigured() {
        boolean retval = false;
        if (this.getPassportID() != null && this.getPassportID().length() > 4) {
            String flagBit = this.getPassportID().substring(0, 1);
            retval = flagBit.equals(FLAG_SET);
        }
        return retval;
    }

    public boolean canCurrentUserCallLogon() {
        return this.canUserLogon;
    }

    protected String getAction() {
        return this.action;
    }

    public int getPassportGeneration() {
        return this.generation;
    }

    public String getPassportID() {
        return this.passportID;
    }

    protected int getVersion() {
        return this.version;
    }

    public boolean isCamConfiguredForAnonymous() {
        boolean retval = false;
        if (this.getPassportID() != null && this.getPassportID().length() > 4) {
            String flagBit = this.getPassportID().substring(1, 2);
            retval = flagBit.equals(FLAG_SET);
        }
        return retval;
    }

    public boolean isCurrentUserAnonymous() {
        boolean retval = false;
        if (this.getPassportID() != null && this.getPassportID().length() > 4) {
            String flagBit = this.getPassportID().substring(2, 3);
            retval = !flagBit.equals(FLAG_SET);
        }
        return retval;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public static boolean isAnonymousAvailable(String passport) {
        if (passport == null) {
            return false;
        }
        CAMCookie c = new CAMCookie(passport);
        return c.isCamConfiguredForAnonymous();
    }

    public static boolean isAnonymous(String passport) {
        if (passport == null) {
            return false;
        }
        CAMCookie c = new CAMCookie(passport);
        return c.isCurrentUserAnonymous();
    }
}

