/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.cam;

public final class CCLWeb64 {
    private static final char web64PadChar = '_';
    private static final byte[] web64DecodeTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 63, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};

    public static byte[] decode(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("Web64 decode string can't be null");
        }
        byte[] baRet = null;
        byte[] baBuffer = null;
        int nIdxOut = 0;
        try {
            int len = str.length();
            if (len % 4 != 0) {
                throw new IllegalArgumentException("String's length (" + len + ") is not a multiple of 4");
            }
            int rsize = (len / 4 + 1) * 3;
            baBuffer = new byte[rsize];
            for (int i = 0; i < len; ++i) {
                int c = web64DecodeTable[(byte)str.charAt(i++)];
                int c1 = web64DecodeTable[(byte)str.charAt(i++)];
                c = c << 2 & 0xFC | c1 >> 4 & 3;
                baBuffer[nIdxOut++] = (byte)c;
                if (str.charAt(i) != '_') {
                    c = web64DecodeTable[(byte)str.charAt(i++)];
                    c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                    baBuffer[nIdxOut++] = (byte)c1;
                    if (str.charAt(i) != '_') {
                        c1 = web64DecodeTable[(byte)str.charAt(i)];
                        c = c << 6 & 0xC0 | c1 & 0x3F;
                        baBuffer[nIdxOut++] = (byte)c;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to decode string '" + str + "'");
        }
        baRet = new byte[nIdxOut];
        System.arraycopy(baBuffer, 0, baRet, 0, nIdxOut);
        return baRet;
    }
}

