/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client;

import com.cognos.mobile.client.IResourceExplorer;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.model.data.AtomFeedNode;
import com.cognos.mobile.task.ITaskMonitor;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public final class AtomFeedSystem
implements IResourceExplorer {
    private static final Hashtable EMPTY = new Hashtable(0);
    private final Hashtable cacheSourcePath = new Hashtable();
    private final MobileServiceProxy service;

    public AtomFeedSystem(MobileServiceProxy service) {
        this.service = service;
    }

    @Override
    public final String getHostType() {
        return "Cognos Atom Feed";
    }

    private AtomFeedNode[] getCached(String path) {
        return (AtomFeedNode[])this.cacheSourcePath.get(path);
    }

    @Override
    public boolean isCached(String path) {
        return this.cacheSourcePath.containsKey(path);
    }

    public final void reset() {
        this.cacheSourcePath.clear();
    }

    @Override
    public Object connect(String path) throws IOException {
        return this.getAtomFeedNode(path);
    }

    @Override
    public Hashtable describe(String path) throws IOException {
        AtomFeedNode node = this.getAtomFeedNode(path);
        if (node == null) {
            return EMPTY;
        }
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("sourcepath", node.getAtomFullTitle());
        t.put("cmpath", node.getCmPath());
        t.put("type", node.getCmObjectClass());
        t.put("label", node.getAtomTitle());
        return t;
    }

    public static String getName(String path) {
        String[] s = CMStringHelper.split(path, '/', false);
        if (s.length == 0) {
            return path;
        }
        return s[s.length - 1];
    }

    @Override
    public String getParent(String path) {
        return CMPathHelper.getParent(path);
    }

    private String[] render(AtomFeedNode[] node) {
        String[] r = new String[node.length];
        for (int i = 0; i < node.length; ++i) {
            String n = node[i].getAtomTitle();
            r[i] = node[i].getType() != 51 ? n + "/" : n;
        }
        return r;
    }

    @Override
    public String[] listRoots() throws IOException {
        return this.list("/", false);
    }

    public AtomFeedNode[] listAsPortalItems(String path) {
        if (CMPathHelper.isFile(path)) {
            return new AtomFeedNode[]{this.getAtomFeedNode(path)};
        }
        return this.getCached(path);
    }

    public AtomFeedNode getAtomFeedNode(String path) {
        String parent = this.getParent(path);
        AtomFeedNode[] node = this.getCached(parent);
        if (node == null) {
            return null;
        }
        for (int i = 0; i < node.length; ++i) {
            if (!(node[i].getType() != 51 ? path.equals(node[i].getAtomFullTitle() + "/") : path.equals(node[i].getAtomFullTitle()))) continue;
            return node[i];
        }
        return null;
    }

    @Override
    public String[] list(String path) throws IOException {
        return this.list(path, false);
    }

    public String[] list(String path, boolean refresh) throws IOException {
        try {
            if (!this.isCached(path) || refresh) {
                if (path.equals("/")) {
                    AtomFeedNode root = new AtomFeedNode();
                    root = this.service.browseAtomFeed(root, ITaskMonitor.NULL);
                    Vector v = root.getChildren();
                    AtomFeedNode[] afn = new AtomFeedNode[v.size()];
                    for (int i = 0; i < v.size(); ++i) {
                        afn[i] = (AtomFeedNode)v.elementAt(i);
                    }
                    System.out.println("putting path: " + path);
                    this.cacheSourcePath.put(path, afn);
                } else {
                    AtomFeedNode node = this.getAtomFeedNode(path);
                    if (node != null) {
                        node = this.service.browseAtomFeed(node, null);
                        Vector v = node.getChildren();
                        AtomFeedNode[] tnp = new AtomFeedNode[v.size()];
                        for (int i = 0; i < v.size(); ++i) {
                            tnp[i] = (AtomFeedNode)v.elementAt(i);
                        }
                        System.out.println("putting path: " + path);
                        this.cacheSourcePath.put(path, tnp);
                    }
                }
            }
            return this.render(this.getCached(path));
        }
        catch (CMException cme) {
            throw new IOException(cme.toString());
        }
    }
}

