/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client;

import com.cognos.mobile.client.GPSWarmUpTaskRunner;
import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.client.IOptionsListener;
import com.cognos.mobile.client.LeaseKeyChecker;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.CMIntSet;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.CMUrlConstants;
import com.cognos.mobile.common.CMUrlHelper;
import com.cognos.mobile.common.ExceptionCracker;
import com.cognos.mobile.common.ICredentialPrompter;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.configuration.HashtableConfiguration;
import com.cognos.mobile.configuration.IConfiguration;
import com.cognos.mobile.event.Event;
import com.cognos.mobile.event.ICookieManager;
import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.event.IServerResponseListener;
import com.cognos.mobile.inbox.EmptyInbox;
import com.cognos.mobile.inbox.IInboxSource;
import com.cognos.mobile.inbox.S2Inbox;
import com.cognos.mobile.location.LocationServices;
import com.cognos.mobile.model.data.About;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.model.ui.PreferredSyncHelper;
import com.cognos.mobile.request.KeyResponseHandler;
import com.cognos.mobile.task.CancellationException;
import com.cognos.mobile.task.ICancellable;
import com.cognos.mobile.task.IMonitorableTask;
import com.cognos.mobile.task.IMonitorableTaskRunner;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.task.IThreadPool;
import com.cognos.mobile.vm.ISerializer;
import com.cognos.mobile.vm.IVMCache;
import com.cognos.mobile.vm.IVMPainter;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMInbox;
import com.cognos.mobile.vm.VMOptions;
import com.cognos.mobile.vm.VMRender;
import com.cognos.mobile.vm.render.SceneManager;
import com.cognos.mobile.vm.render.SceneManagerStack;
import java.util.Hashtable;

public class Controller
implements IEventListener,
ICookieManager,
IServerResponseListener,
IOptionsListener {
    private static final Class CLASS = Controller.class;
    private final MobileServiceProxy mobileService;
    private final IEventManager eventManager;
    private final VMOptions options;
    private final VMInbox inbox;
    private final IClientApplication clientApplication;
    private final IMonitorableTaskRunner monitorableTaskRunner;
    private final ISerializer serializer;
    private final IThreadPool threadPool;
    private final LocationServices locationServices;
    private final IResourceManager resourceManager;
    private GPSWarmUpTaskRunner gpsWarmUpRunner;
    private SceneManagerStack sceneManagerStack;
    private LeaseKeyChecker leaseKeyChecker;
    private IVMCache cache = IVMCache.NULL;
    private final Object lock = new Object();
    private IConfiguration serverSettings;
    private About serverAbout;
    public static int LOGON_OPTION_DEFAULT = 0;
    public static int LOGON_OPTION_IGNORE_VERSION_RESTRICTIONS = 1;
    public static final int MODE_RUN = 1;
    public static final int MODE_DRILLTHROUGH = 2;
    public static final int MODE_DRILL_UP = 3;
    public static final int MODE_DRILL_DOWN = 4;
    private ICancellable nextCallCancellable = ICancellable.NULL;

    public Controller(IEventManager eventManager, VMOptions options, VMInbox inbox, IClientApplication clientApplication, MobileServiceProxy mobileService, IMonitorableTaskRunner monitorableTaskRunner, ISerializer serializer, IThreadPool threadPool, IResourceManager resourceManager) throws CMException {
        if (options == null) {
            throw new NullPointerException("controller: options can't be null");
        }
        this.eventManager = eventManager;
        this.options = options;
        this.inbox = inbox;
        this.clientApplication = clientApplication;
        this.mobileService = mobileService;
        this.monitorableTaskRunner = monitorableTaskRunner;
        this.leaseKeyChecker = new LeaseKeyChecker(eventManager, options);
        this.serializer = serializer;
        this.sceneManagerStack = new SceneManagerStack();
        this.threadPool = threadPool;
        this.locationServices = new LocationServices(clientApplication, options, eventManager);
        this.resourceManager = resourceManager;
        this.mobileService.addServerRequestModifier(this.locationServices);
        this.mobileService.addServerRequestModifier(this.inbox);
        this.mobileService.setCookieManager(this);
        this.mobileService.setLeaseKeyChecker(this.leaseKeyChecker);
        this.mobileService.setServerResponseListener(this);
        this.options.setPlatform(clientApplication.getPlatformID());
        this.options.setOptionsListener(this);
        this.gpsWarmUpRunner = new GPSWarmUpTaskRunner(threadPool, options, clientApplication, this.getLocationServices(), resourceManager);
        eventManager.addEventListener(this);
    }

    public LocationServices getLocationServices() {
        return this.locationServices;
    }

    public void setAbout(About about) throws CMException {
        this.serverAbout = about;
        this.options.setAbout(about);
        this.options.save();
    }

    public IConfiguration getServerSettings() {
        return this.serverSettings;
    }

    public About getServerAbout() {
        return this.serverAbout;
    }

    public SceneManagerStack getSceneManagerStack() {
        return this.sceneManagerStack;
    }

    private String getInboxName() {
        VM.log(CLASS, 1, "Controller.getInboxName: ");
        if (this.options.getServerUrl() == null) {
            return null;
        }
        if (this.options.getUserName() == null) {
            return null;
        }
        VM.log(CLASS, 1, "Controller.getInboxName: " + this.options.getServerUrl() + ":" + this.options.getUserName());
        return CMUrlHelper.encodeUrl(this.options.getServerUrl() + ":" + this.options.getUserName() + ".ibx");
    }

    public IMonitorableTaskRunner getMonitorableTaskRunner() {
        return this.monitorableTaskRunner;
    }

    public void logon(ICredentialPrompter credentialPrompter) throws CMException {
        this.logon(credentialPrompter, LOGON_OPTION_DEFAULT);
    }

    public void logon(ICredentialPrompter credentialPrompter, int logonOptions) throws CMException {
        VM.log(CLASS, 1, "logon requested; offer prompt for server...");
        String serverUrl = credentialPrompter.promptServerUrl(this.options.getServerUrl(), null);
        if (serverUrl == null || serverUrl.length() == 0) {
            return;
        }
        VM.log(CLASS, 1, "setting the serverUrl to: " + serverUrl);
        this.options.setServerUrl(serverUrl, true);
        this.options.save();
        VM.log(CLASS, 1, "Running the monitorable task to log in...");
        LogonMonitorableTask t = new LogonMonitorableTask(logonOptions, credentialPrompter);
        VM.log(CLASS, 1, "Created task to log in...");
        this.monitorableTaskRunner.run(t);
        VM.log(CLASS, 1, "Submitted task to run...");
    }

    public void logoff() throws CMException {
        VM.log(CLASS, 1, "Logging off...");
        try {
            String filename = this.getInboxName();
            if (filename != null) {
                this.serializer.save(this.inbox, filename);
            }
        }
        catch (CMException cMException) {
            // empty catch block
        }
        this.options.clearServerState();
        this.options.setDemoMode(false, null);
        this.options.save();
        this.inbox.setInboxSource(EmptyInbox.instance);
        this.clientApplication.onLogoff();
    }

    public void refreshInbox(ITaskMonitor taskMonitor) throws CMException {
        VM.log(CLASS, 1, "Refreshing inbox...");
        this.inbox.getInboxSource().refresh(taskMonitor);
    }

    public void refreshInbox(boolean showMonitor) throws CMException {
        VM.log(CLASS, 1, "Refreshing inbox; show monitor? " + showMonitor);
        if (!showMonitor) {
            this.refreshInbox(null);
        } else {
            this.monitorableTaskRunner.run(new IMonitorableTask(){

                @Override
                public String getInitialText1ID() {
                    return CMIDs.DOWNLOADING_1;
                }

                @Override
                public String getInitialText2ID() {
                    return CMIDs.DOWNLOADING_2;
                }

                @Override
                public String getInitialButtonTextID() {
                    return CMIDs.DOWNLOADING_BUTTON;
                }

                @Override
                public Object run(ITaskMonitor taskMonitor) throws CMException {
                    VM.log(CLASS, 1, "refreshing inbox");
                    Controller.this.refreshInbox(taskMonitor);
                    VM.log(CLASS, 1, "refreshed inbox");
                    Controller.this.clientApplication.triggerInboxRefreshedAlert();
                    return null;
                }
            });
        }
    }

    public void start(IInboxSource demoInboxSource, IVMCache demoCache, String demoInboxName) throws CMException {
        String filename = this.getInboxName();
        if (filename != null) {
            try {
                this.serializer.load(this.inbox, filename);
            }
            catch (CMException e) {
                VM.log(CLASS, 3, "couldn't load inbox", e);
            }
        }
        if (demoInboxSource != null) {
            this.setDemoInbox(demoInboxSource, demoInboxName);
        }
        if (demoCache != null) {
            this.cache = demoCache;
        }
        if (this.options.getAuthenticationState() == 1 || this.options.getAuthenticationState() == 2) {
            if (this.options.getCacheEncryption() == 1) {
                try {
                    VM.log(CLASS, 0, "getting key...");
                    KeyResponseHandler krh = this.mobileService.getKey(null, this.clientApplication.getPlatformID());
                    VM.log(CLASS, 0, "creating cache...");
                    this.cache = this.clientApplication.createCache(krh.getKeyType(), krh.getKey());
                }
                catch (Exception e) {
                    VM.log(CLASS, 1, "lease has expired");
                    this.logoff();
                }
            } else {
                VM.log(CLASS, 0, "creating cache...");
                this.cache = this.clientApplication.createCache(CMUrlConstants.KEY_NONE, null);
            }
            this.changeSyncMethodIfNecessary(false);
            this.gpsWarmUpRunner.start();
        }
        this.locationServices.refreshState(this.options.getUseLocation());
        this.eventManager.postEvent(new Event(this, 11, this.options));
        this.eventManager.postEvent(new Event(this, 10));
        this.eventManager.postEvent(new Event(this, 7, Boolean.TRUE));
    }

    public void saveInbox() {
        try {
            String filename = this.getInboxName();
            if (filename != null) {
                this.serializer.save(this.inbox, filename);
            }
        }
        catch (Throwable ex) {
            VM.log(CLASS, 3, "problem saving state", ex);
        }
    }

    public void stop() {
        try {
            String filename = this.getInboxName();
            if (filename != null) {
                this.serializer.save(this.inbox, filename);
            }
            this.serializer.save(this.options, VMOptions.SERIALIZED_NAME);
            if (this.inbox != null) {
                this.inbox.dispose();
            }
            if (this.clientApplication != null) {
                this.clientApplication.dispose();
            }
        }
        catch (Throwable ex) {
            VM.log(CLASS, 3, "unclean shutdown", ex);
        }
    }

    public void setDemoInbox(IInboxSource demoInboxSource, String demoInboxName) {
        this.inbox.setInboxSource(demoInboxSource);
        this.options.setDemoMode(true, demoInboxName);
        this.eventManager.postEvent(new Event(this, 10));
    }

    public void triggerSyncStartingNotification() {
        if (this.eventManager != null) {
            String msg = this.resourceManager.loadString(CMIDs.SYNC_STARTING);
            this.eventManager.postEvent(new Event(this, 14, msg));
        }
    }

    public void runReport(IResourceManager resourceManager, String storeID) throws CMException {
        VM.log(CLASS, 0, "begin: runReport");
        RunReportTask rrt = new RunReportTask(resourceManager, 1, storeID);
        SceneManagerStack sceneManagerStack = (SceneManagerStack)this.monitorableTaskRunner.run(rrt);
        if (sceneManagerStack == null) {
            VM.log(CLASS, 0, "no stack; showing tooltip");
        } else {
            VM.log(CLASS, 0, "displaying render");
            this.clientApplication.showRender(sceneManagerStack);
        }
        VM.log(CLASS, 0, "end: runReport");
    }

    public void drillUpDown(IResourceManager resourceManager, int sourceRenderID, int mode, String context, int widgetId, int pageIndex) throws CMException {
        VM.log(CLASS, 0, "begin: runDrillUpDown");
        RunReportTask rrt = new RunReportTask(resourceManager, mode, context, sourceRenderID, widgetId, pageIndex);
        SceneManagerStack sceneManagerStack = (SceneManagerStack)this.monitorableTaskRunner.run(rrt);
        if (sceneManagerStack == null) {
            VM.log(CLASS, 0, "no stack; showing tooltip");
        } else {
            VM.log(CLASS, 0, "displaying render");
            this.clientApplication.showRender(sceneManagerStack);
        }
        VM.log(CLASS, 0, "end: runDrillUpDown");
    }

    public void drillThrough(IResourceManager resourceManager, String context) throws CMException {
        VM.log(CLASS, 0, "begin: runReport");
        RunReportTask rrt = new RunReportTask(resourceManager, 2, context);
        SceneManagerStack sceneManagerStack = (SceneManagerStack)this.monitorableTaskRunner.run(rrt);
        if (sceneManagerStack == null) {
            VM.log(CLASS, 0, "no stack; showing tooltip");
        } else {
            VM.log(CLASS, 0, "displaying render");
            this.clientApplication.showRender(sceneManagerStack);
        }
        VM.log(CLASS, 0, "end: runReport");
    }

    private SceneManagerStack sharedOpenRenderLogic(ITaskMonitor taskMonitor, int renderID, int pageIndex, IResourceManager resourceManager) throws CMException {
        if (this.inbox.getInboxSource().enforceLeases() && this.leaseKeyChecker.isLeaseExpired()) {
            VM.log(CLASS, 3, "lease has expired");
            this.logoff();
            throw new CMException(2023);
        }
        VMRender render = this.inbox.getRenderByRenderID(renderID, pageIndex, taskMonitor, false);
        if (render == null) {
            throw new CMException(1160, "failed to get the report from the inbox.");
        }
        this.inbox.markRenderAsOpened(render.getMeta().renderID, true);
        taskMonitor.throwIfCancelled();
        taskMonitor.nextStep();
        SceneManager currentSceneManager = this.sceneManagerStack.peek();
        if (currentSceneManager == null || currentSceneManager.getRender() == null || currentSceneManager.getRender().getRenderId() == renderID) {
            // empty if block
        }
        this.sceneManagerStack.pushRender(this.options, render, resourceManager, this.clientApplication, this.cache, this.mobileService);
        taskMonitor.throwIfCancelled();
        taskMonitor.nextStep();
        int cxViewport = this.clientApplication.getScreenDimensions().x;
        int cyViewport = this.clientApplication.getScreenDimensions().y;
        IVMPainter painter = this.clientApplication.getPainter(render, this.cache);
        this.sceneManagerStack.peek().gotoPage(pageIndex, cxViewport, cyViewport, painter, null, 240, taskMonitor);
        taskMonitor.throwIfCancelled();
        taskMonitor.nextStep();
        return this.sceneManagerStack;
    }

    public void openRenderByID(int renderID, IResourceManager resourceManager) {
        this.openRenderByID(renderID, 0, resourceManager);
    }

    public void openRenderByID(final int renderID, final int pageIndex, final IResourceManager resourceManager) {
        block12: {
            SceneManagerStack rc = null;
            IMonitorableTask theTask = null;
            try {
                if (this.inbox.isDeletedRender(renderID)) {
                    VMRender deletedRender;
                    if (this.inbox.checkIfRenderExists(renderID, pageIndex) && (deletedRender = this.inbox.getRenderByRenderID(renderID, pageIndex, ITaskMonitor.NULL, true)) != null) {
                        theTask = new RunReportTask(resourceManager, 1, deletedRender.getMeta().storeID);
                    }
                } else if (!this.inbox.checkIfRenderExists(renderID, pageIndex) && this.inbox.checkIfRenderExists(renderID, 0)) {
                    theTask = new RunReportPageTask(renderID, pageIndex);
                }
                if (theTask == null) {
                    theTask = new IMonitorableTask.SteppedMonitorableTask(){

                        @Override
                        public int totalSteps() {
                            return 6;
                        }

                        @Override
                        public String getInitialText1ID() {
                            return CMIDs.OPEN_1;
                        }

                        @Override
                        public String getInitialText2ID() {
                            return CMIDs.OPEN_2;
                        }

                        @Override
                        public String getInitialButtonTextID() {
                            return CMIDs.OPEN_BUTTON;
                        }

                        @Override
                        public Object run(ITaskMonitor taskMonitor) throws CMException {
                            return Controller.this.sharedOpenRenderLogic(taskMonitor, renderID, pageIndex, resourceManager);
                        }
                    };
                }
                rc = (SceneManagerStack)this.monitorableTaskRunner.run(theTask);
            }
            catch (Throwable t) {
                if (this.clientApplication != null) {
                    this.clientApplication.onException("openRender", t);
                }
                return;
            }
            try {
                if (rc != null && rc == this.sceneManagerStack) {
                    this.clientApplication.showRender(this.sceneManagerStack);
                } else {
                    VM.log(CLASS, 2, "2019 - null or invalid sceneManagerStack");
                }
            }
            catch (Throwable t) {
                if (this.clientApplication == null) break block12;
                this.clientApplication.onException("openRender", t);
            }
        }
    }

    public void composeDiagnosticEmail(Throwable ex, ExceptionCracker.Data data) {
        StringBuffer sb = new StringBuffer();
        sb.append("(Provide additional details here.)\n\n");
        sb.append("-------\n");
        sb.append("IBM Cognos Mobile 11.2.7 for RIM OS ?\n");
        if (data != null) {
            sb.append("-------\n");
            sb.append("Error '" + data.errorCodeString + "' (" + data.errorCode + ")\n");
            sb.append(data.message + "\n");
            sb.append(data.details + "\n");
        }
        if (ex != null) {
            sb.append("-------\n");
            sb.append(ex.toString() + "\n");
        }
        sb.append("-------\n");
        this.options.dump(sb);
        sb.append("-------\n");
        this.mobileService.dump(sb);
        sb.append("-------\n");
        this.clientApplication.dump(sb);
        this.clientApplication.composeEmail("Go! Mobile Diagnostics", sb.toString());
    }

    @Override
    public void onEvent(IEvent event) {
        VM.log(CLASS, 0, "event " + event.toString());
        switch (event.getCode()) {
            case 3: 
            case 7: {
                Boolean includesNewRenders;
                if (event.getArgument() != null && event.getArgument() instanceof Boolean && (includesNewRenders = (Boolean)event.getArgument()) != null && includesNewRenders.booleanValue()) {
                    this.clientApplication.triggerNewRendersAlert();
                }
                this.gpsWarmUpRunner.start();
                break;
            }
            case 11: {
                if (this.options.getAuthenticationState() == 1 || this.options.getAuthenticationState() == 2) {
                    try {
                        this.changeSyncMethodIfNecessary(true);
                    }
                    catch (CMException e) {
                        VM.log(CLASS, 3, "error while changing sync method", e);
                    }
                }
                this.gpsWarmUpRunner.start();
            }
        }
    }

    @Override
    public String getCookiesHeader() {
        return this.options.getCookiesHeader();
    }

    @Override
    public void setCookie(String key, String value) throws CMException {
        this.options.setCookie(key, value);
        if (key.equals("mob_session")) {
            if (CMStringHelper.compareStrings(this.options.getSessionCookieProperty("p"), this.clientApplication.getPlatformID()) != 0) {
                this.options.setSessionCookieProperty("p", this.clientApplication.getPlatformID());
            }
            if (CMStringHelper.compareStrings(this.options.getSessionCookieProperty("di"), this.clientApplication.getDeviceID()) != 0) {
                this.options.setSessionCookieProperty("di", this.clientApplication.getDeviceID());
            }
        }
    }

    @Override
    public void setSettings(IConfiguration serverSettings) {
        VM.log(CLASS, 0, "received server settings");
        this.serverSettings = serverSettings;
        this.eventManager.postEvent(new Event(this, 8, serverSettings));
    }

    @Override
    public void setS2Inbox(CMIntSet inboxItems) {
        IInboxSource inboxSource = this.inbox.getInboxSource();
        if (inboxSource instanceof S2Inbox) {
            S2Inbox s2Inbox = (S2Inbox)inboxSource;
            s2Inbox.setInbox(inboxItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNextCall(int seconds) {
        Object object = this.lock;
        synchronized (object) {
            if (this.inbox.getInboxSource() instanceof S2Inbox) {
                this.nextCallCancellable.cancel();
                this.nextCallCancellable = this.threadPool.executeBackground(new Runnable(){

                    public String toString() {
                        return "refresh inbox";
                    }

                    @Override
                    public void run() {
                        try {
                            Controller.this.refreshInbox(false);
                        }
                        catch (Exception e) {
                            VM.log(CLASS, 3, "Problem refreshing the inbox", e);
                        }
                    }
                }, seconds * 1000);
            }
        }
    }

    @Override
    public void serverChanged() throws CMException {
        this.options.clearCredentials();
        this.logoff();
    }

    private void changeSyncMethodIfNecessary(boolean refreshInboxRequired) throws CMException {
        String effectiveSyncMethod = PreferredSyncHelper.getEffectiveSyncMethod(this.options, this.clientApplication, this.cache);
        String currentSyncMethod = this.inbox.getInboxSource().getSyncMethod();
        this.options.setSessionCookieProperty("esm", effectiveSyncMethod);
        if (!effectiveSyncMethod.equals(currentSyncMethod)) {
            IInboxSource inboxSource = effectiveSyncMethod.equals("N") ? EmptyInbox.instance : this.clientApplication.createInboxSource(effectiveSyncMethod, this.cache);
            this.inbox.setInboxSource(inboxSource);
            if (refreshInboxRequired) {
                this.refreshInbox(true);
            }
            VM.log(CLASS, 0, "changed sync method from '" + currentSyncMethod + "' to '" + effectiveSyncMethod + "'");
        }
    }

    private void setCacheEncryptionValue(KeyResponseHandler krh, VMOptions options) throws CMException {
        boolean optionsChanged = false;
        if (krh.getKeyType() == null || krh.getKeyType().equalsIgnoreCase("NONE")) {
            if (options.getCacheEncryption() != 0) {
                options.setCacheEncryption(0);
                optionsChanged = true;
            }
        } else if (options.getCacheEncryption() != 1) {
            options.setCacheEncryption(1);
            optionsChanged = true;
        }
        if (optionsChanged) {
            options.save();
            this.eventManager.postEvent(new Event(this, 11, options));
        }
    }

    private class RunReportPageTask
    implements IMonitorableTask,
    IEventListener,
    ICancellable {
        private final Class CLASS = RunReportPageTask.class;
        final int renderID;
        final int pageIndex;
        private final Object lock = new Object();

        public RunReportPageTask(int renderID, int pageIndex) {
            this.renderID = renderID;
            this.pageIndex = pageIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run(ITaskMonitor taskMonitor) throws CMException {
            taskMonitor.setDescriptions(CMIDs.DOWNLOAD_REPORT_1, CMIDs.DOWNLOAD_REPORT_2, CMIDs.DOWNLOAD_REPORT_BUTTON);
            taskMonitor.setCancellableObject(this);
            boolean found = false;
            VMRender renderWithThatPage = null;
            while (true) {
                taskMonitor.throwIfCancelled();
                VM.log(this.CLASS, 0, "sleeping...");
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                renderWithThatPage = Controller.this.inbox.getRenderByRenderID(this.renderID, this.pageIndex, ITaskMonitor.NULL, false);
                if (renderWithThatPage != null) break;
                VM.log(this.CLASS, 0, "didn't find render " + this.renderID);
            }
            VM.log(this.CLASS, 0, "found render " + this.renderID);
            found = true;
            taskMonitor.setCancellableObject(ICancellable.NULL);
            SceneManagerStack sceneManagerStack = null;
            if (found) {
                taskMonitor.setDescriptions(CMIDs.OPEN_1, CMIDs.OPEN_2, CMIDs.OPEN_BUTTON);
                VM.log(this.CLASS, 0, "start: setting up scene");
                sceneManagerStack = Controller.this.sharedOpenRenderLogic(taskMonitor, this.renderID, this.pageIndex, Controller.this.resourceManager);
                VM.log(this.CLASS, 0, "end: setting up scene");
            } else {
                VM.log(this.CLASS, 0, "no scene; user must have cancelled");
            }
            return sceneManagerStack;
        }

        @Override
        public String getInitialText1ID() {
            return CMIDs.COMPILE_REPORT_1;
        }

        @Override
        public String getInitialText2ID() {
            return CMIDs.COMPILE_REPORT_2;
        }

        @Override
        public String getInitialButtonTextID() {
            return CMIDs.COMPILE_REPORT_BUTTON;
        }

        @Override
        public void onEvent(IEvent event) {
            switch (event.getCode()) {
                case 3: {
                    VM.log(this.CLASS, 0, "received 'inbox loaded' event");
                    this.lock.notifyAll();
                    break;
                }
                default: {
                    VM.log(this.CLASS, 0, "received " + event.getCode() + " event");
                }
            }
        }

        @Override
        public void cancel() {
            VM.log(this.CLASS, 0, "cancelled");
            this.lock.notifyAll();
        }
    }

    private class RunReportTask
    implements IMonitorableTask,
    IEventListener,
    ICancellable {
        private final IResourceManager resourceManager;
        private final int mode;
        private final String pathOrContext;
        private final int sourceRenderID;
        private final int widgetId;
        private final int pageIndex;
        private final Object lock = new Object();
        private final Class CLASS = RunReportTask.class;

        public RunReportTask(IResourceManager resourceManager, int mode, String pathOrContext) {
            this.resourceManager = resourceManager;
            this.mode = mode;
            this.pathOrContext = pathOrContext;
            this.sourceRenderID = -1;
            this.widgetId = -1;
            this.pageIndex = 0;
        }

        public RunReportTask(IResourceManager resourceManager, int mode, String pathOrContext, int sourceRenderId, int widgetId, int pageIndex) {
            this.resourceManager = resourceManager;
            this.mode = mode;
            this.pathOrContext = pathOrContext;
            this.sourceRenderID = sourceRenderId;
            this.widgetId = widgetId;
            this.pageIndex = pageIndex;
        }

        @Override
        public String getInitialText1ID() {
            switch (this.mode) {
                case 1: {
                    return CMIDs.COMPILE_REPORT_1;
                }
                case 2: {
                    return CMIDs.DRILL_THROUGH_1;
                }
                case 3: {
                    return CMIDs.DRILL_UP_1;
                }
                case 4: {
                    return CMIDs.DRILL_DOWN_1;
                }
            }
            return null;
        }

        @Override
        public String getInitialText2ID() {
            switch (this.mode) {
                case 1: {
                    return CMIDs.COMPILE_REPORT_2;
                }
                case 2: {
                    return CMIDs.DRILL_THROUGH_2;
                }
                case 3: {
                    return CMIDs.DRILL_UP_2;
                }
                case 4: {
                    return CMIDs.DRILL_DOWN_2;
                }
            }
            return null;
        }

        @Override
        public String getInitialButtonTextID() {
            switch (this.mode) {
                case 1: {
                    return CMIDs.COMPILE_REPORT_BUTTON;
                }
                case 2: {
                    return CMIDs.DRILL_THROUGH_BUTTON;
                }
                case 3: {
                    return CMIDs.DRILL_UP_BUTTON;
                }
                case 4: {
                    return CMIDs.DRILL_DOWN_BUTTON;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run(ITaskMonitor taskMonitor) throws CMException {
            VM.log(this.CLASS, 0, "begin run report task for '" + this.pathOrContext + "'");
            Render render = null;
            if (this.mode == 1) {
                render = Controller.this.mobileService.runReport(this.pathOrContext, taskMonitor);
            } else if (this.mode == 2) {
                render = Controller.this.mobileService.drillThroughReport(this.pathOrContext, taskMonitor);
            } else if (this.mode == 3) {
                render = Controller.this.mobileService.drillUpDownReport(this.sourceRenderID, "UP", this.pathOrContext, this.widgetId, this.pageIndex, taskMonitor);
            } else if (this.mode == 4) {
                render = Controller.this.mobileService.drillUpDownReport(this.sourceRenderID, "DOWN", this.pathOrContext, this.widgetId, this.pageIndex, taskMonitor);
            }
            VM.log(this.CLASS, 0, "ran report for '" + this.pathOrContext + "'");
            if (render == null) {
                return null;
            }
            if (this.mode == 1) {
                taskMonitor.setDescriptions(CMIDs.DOWNLOAD_REPORT_1, CMIDs.DOWNLOAD_REPORT_2, CMIDs.DOWNLOAD_REPORT_BUTTON);
            } else {
                taskMonitor.setDescriptions(CMIDs.DOWNLOAD_REPORT_1, CMIDs.PROGRESS_PLEASE_WAIT, CMIDs.DOWNLOAD_REPORT_BUTTON);
            }
            taskMonitor.setCancellableObject(this);
            boolean found = false;
            while (true) {
                taskMonitor.throwIfCancelled();
                VM.log(this.CLASS, 0, "sleeping...");
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (Controller.this.inbox.findItemFromRenderID(render.renderID) != null) {
                    VM.log(this.CLASS, 0, "found render " + render.renderID);
                    found = true;
                    break;
                }
                if (render.inProgress.getStatus().equals("inProgress")) {
                    Controller.this.mobileService.updateInProgressStatus(render, taskMonitor);
                } else if (Controller.this.inbox.getRequestedRenderStatus(render.renderID) == -1) {
                    VM.log(this.CLASS, 2, "Render deleted while running report: " + render.renderID);
                    found = true;
                    break;
                }
                VM.log(this.CLASS, 0, "didn't find render " + render.renderID);
            }
            Controller.this.inbox.clearRequestedRenderStatus();
            taskMonitor.setCancellableObject(ICancellable.NULL);
            SceneManagerStack sceneManagerStack = null;
            if (found) {
                if (this.mode == 1) {
                    taskMonitor.setDescriptions(CMIDs.OPEN_1, CMIDs.OPEN_2, CMIDs.OPEN_BUTTON);
                } else {
                    taskMonitor.setDescriptions(CMIDs.OPEN_1, CMIDs.PROGRESS_PLEASE_WAIT, CMIDs.OPEN_BUTTON);
                }
                VM.log(this.CLASS, 0, "start: setting up scene");
                sceneManagerStack = Controller.this.sharedOpenRenderLogic(taskMonitor, render.renderID, 0, this.resourceManager);
                VM.log(this.CLASS, 0, "end: setting up scene");
            } else {
                VM.log(this.CLASS, 0, "no scene; user must have cancelled");
            }
            return sceneManagerStack;
        }

        @Override
        public void onEvent(IEvent event) {
            switch (event.getCode()) {
                case 3: {
                    VM.log(this.CLASS, 0, "received 'inbox loaded' event");
                    this.lock.notifyAll();
                    break;
                }
                default: {
                    VM.log(this.CLASS, 0, "received " + event.getCode() + " event");
                }
            }
        }

        @Override
        public void cancel() {
            VM.log(this.CLASS, 0, "cancelled");
            this.lock.notifyAll();
        }
    }

    private final class LogonMonitorableTask
    implements IMonitorableTask.SteppedMonitorableTask {
        private final int logonOptions;
        private final ICredentialPrompter credentialPrompter;

        private LogonMonitorableTask(int logonOptions, ICredentialPrompter credentialPrompter) {
            this.logonOptions = logonOptions;
            this.credentialPrompter = credentialPrompter;
        }

        @Override
        public String getInitialText1ID() {
            return CMIDs.LOGON_1;
        }

        @Override
        public String getInitialText2ID() {
            return CMIDs.LOGON_2;
        }

        @Override
        public String getInitialButtonTextID() {
            return CMIDs.LOGON_BUTTON;
        }

        @Override
        public Object run(ITaskMonitor taskMonitor) throws CMException {
            try {
                VM.log(CLASS, 1, "logging on...");
                taskMonitor.nextStep();
                Hashtable serverSettings = Controller.this.options.getAuthenticationState() == 0 ? Controller.this.mobileService.getSettings(false, taskMonitor) : Controller.this.mobileService.getSettings(true, taskMonitor);
                taskMonitor.nextStep();
                KeyResponseHandler krh = Controller.this.mobileService.getKey(taskMonitor, Controller.this.clientApplication.getPlatformID());
                taskMonitor.nextStep();
                Controller.this.cache = Controller.this.clientApplication.createCache(krh.getKeyType(), krh.getKey());
                Controller.this.setCacheEncryptionValue(krh, Controller.this.options);
                Controller.this.setSettings(new HashtableConfiguration(serverSettings));
                if ((Controller.this.options.getAuthenticationState() == 1 || Controller.this.options.getAuthenticationState() == 2) && Controller.this.cache.canWrite()) {
                    this.cleanCache();
                }
                taskMonitor.nextStep();
                About about = Controller.this.mobileService.getAbout(taskMonitor, false);
                taskMonitor.nextStep();
                if ((this.logonOptions & LOGON_OPTION_IGNORE_VERSION_RESTRICTIONS) == 0) {
                    int serverMinor2Version = -1;
                    int serverMinor3Version = -1;
                    try {
                        int serverMajorVersion = Integer.parseInt(about.versionMajor);
                        int serverMinorVersion = Integer.parseInt(about.versionMinor);
                        if (about.versionMinor2 != null) {
                            serverMinor2Version = Integer.parseInt(about.versionMinor2);
                        }
                        if (about.versionMinor3 != null) {
                            serverMinor3Version = Integer.parseInt(about.versionMinor3);
                        }
                        boolean serverIsOlder = false;
                        if (serverMajorVersion < 11) {
                            serverIsOlder = true;
                        }
                        if (serverMajorVersion == 11 && serverMinorVersion < 2) {
                            serverIsOlder = true;
                        }
                        if (serverMajorVersion == 11 && serverMinorVersion == 2) {
                            if (serverMinor2Version < 2) {
                                serverIsOlder = true;
                            } else if (serverMinor2Version == 2 && serverMinor3Version < 2) {
                                serverIsOlder = true;
                            }
                        }
                        if (serverIsOlder) {
                            Controller.this.logoff();
                            throw new CMException(2026);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new CMException(2010, "Could not parse the server version");
                    }
                }
                Controller.this.setAbout(about);
                taskMonitor.nextStep();
                Controller.this.changeSyncMethodIfNecessary(false);
                try {
                    VM.log(CLASS, 2, "Attempting to load inbox");
                    String filename = Controller.this.getInboxName();
                    VM.log(CLASS, 2, "Ok, this is what we are looking for: " + filename);
                    if (filename != null) {
                        Controller.this.serializer.load(Controller.this.inbox, filename);
                    }
                }
                catch (CMException e) {
                    VM.log(CLASS, 2, "couldn't load inbox");
                }
                taskMonitor.setDescriptions(CMIDs.DOWNLOADING_1, CMIDs.DOWNLOADING_2, CMIDs.DOWNLOADING_BUTTON);
                Controller.this.inbox.getInboxSource().refresh(taskMonitor);
                taskMonitor.nextStep();
                Controller.this.clientApplication.onLogon();
                taskMonitor.nextStep();
                Controller.this.eventManager.postEvent(new Event(this, 7, Boolean.FALSE));
                VM.log(CLASS, 0, "finished logging on");
                return null;
            }
            catch (CMException cme) {
                VM.log(CLASS, 1, "Controller.logon(...).new SteppedMonitorableTask() {...}.run: CMException thrown: " + cme);
                if (cme.getErrorCode() == 1175) {
                    Controller.this.logoff();
                }
                throw cme;
            }
            catch (CancellationException ce) {
                VM.log(CLASS, 1, "Controller.logon(...).new SteppedMonitorableTask() cancelled!");
                VM.log(CLASS, 1, "Authstate: " + Controller.this.options.getAuthenticationState() + " =? " + 0);
                if (Controller.this.options.getAuthenticationState() == 0) {
                    return null;
                }
                throw ce;
            }
            catch (RuntimeException re) {
                VM.log(CLASS, 1, "Controller.logon(...).new SteppedMonitorableTask() {...}.run: RuntimeException thrown: " + re);
                if (Controller.this.options.getAuthenticationState() == 0) {
                    Controller.this.logon(this.credentialPrompter, this.logonOptions);
                    return null;
                }
                throw re;
            }
            catch (Throwable re) {
                VM.log(CLASS, 1, "Controller.logon(...).new SteppedMonitorableTask() {...}.run: Throwable thrown: " + re);
                if (Controller.this.options.getAuthenticationState() == 0) {
                    Controller.this.logon(this.credentialPrompter, this.logonOptions);
                    return null;
                }
                throw new CMException(2007, re);
            }
        }

        private void cleanCache() throws CMException {
            IVMCache.Entry[] entries = Controller.this.cache.list();
            for (int i = 0; i < entries.length; ++i) {
                int dot2;
                if (!entries[i].filename.endsWith(".db") && !entries[i].filename.endsWith(".dbz")) continue;
                int userID = -1;
                int dot1 = entries[i].filename.indexOf(46);
                if (dot1 >= 0 && (dot2 = entries[i].filename.indexOf(46, dot1 + 2)) >= dot1 + 2) {
                    try {
                        userID = Integer.parseInt(entries[i].filename.substring(dot1 + 1, dot2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (Controller.this.options.getUserID().equalsIgnoreCase(String.valueOf(userID))) continue;
                try {
                    Controller.this.cache.delete(entries[i].filename);
                    VM.log(CLASS, 1, "deleted cache entry '" + entries[i].filename + "'");
                    continue;
                }
                catch (Throwable t) {
                    VM.log(CLASS, 2, "error deleting cache entry '" + entries[i].filename + "'", t);
                }
            }
        }

        @Override
        public int totalSteps() {
            return 8;
        }
    }
}

