/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.event.IEvent;
import com.cognos.mobile.event.IEventListener;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;

public class LeaseKeyChecker
implements IEventListener {
    private final Class CLASS = LeaseKeyChecker.class;
    private static final long MILLIS_PER_SECOND = 1000L;
    private final VMOptions options;
    private int leaseDurationSeconds = -1;
    private long leaseStartTimeInMillis;

    public LeaseKeyChecker(IEventManager eventManager, VMOptions options) {
        this.options = options;
        eventManager.addEventListener(this);
        this.readLeaseDuration();
    }

    public void renewLease() throws CMException {
        this.leaseStartTimeInMillis = System.currentTimeMillis();
        this.options.setLeaseStartTimeMillis(this.leaseStartTimeInMillis);
        this.options.save();
        VM.log(this.CLASS, 1, "lease renewed");
    }

    public boolean isLeaseExpired() {
        if (this.leaseDurationSeconds <= 0) {
            this.readLeaseDuration();
        }
        if (this.leaseDurationSeconds <= 0) {
            return false;
        }
        long elapsedTimeInSeconds = (System.currentTimeMillis() - this.leaseStartTimeInMillis) / 1000L;
        if (elapsedTimeInSeconds >= (long)this.leaseDurationSeconds) {
            VM.log(this.CLASS, 2, "lease has expired; lease is " + elapsedTimeInSeconds + "s  old but the device still has connectivity to server.");
            return true;
        }
        return false;
    }

    @Override
    public void onEvent(IEvent event) {
        switch (event.getCode()) {
            case 8: 
            case 11: {
                this.readLeaseDuration();
                break;
            }
            case 10: {
                if (this.options == null) break;
                switch (this.options.getAuthenticationState()) {
                    default: 
                }
            }
        }
    }

    private void readLeaseDuration() {
        if (this.options != null) {
            this.leaseDurationSeconds = this.options.getLeaseDurationSeconds();
            this.leaseStartTimeInMillis = this.options.getLeaseStartTimeMillis();
            VM.log(this.CLASS, 2, "lease duration set to " + this.leaseDurationSeconds + "s");
        }
    }
}

