/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client;

import com.cognos.mobile.client.IResourceExplorer;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.model.data.PortalItem;
import com.cognos.mobile.task.ITaskMonitor;
import java.io.IOException;
import java.util.Hashtable;

public final class PortalSystem
implements IResourceExplorer {
    private static final Hashtable EMPTY = new Hashtable(0);
    private final Hashtable cacheSourcePath = new Hashtable();
    private final MobileServiceProxy service;

    public PortalSystem(MobileServiceProxy service) {
        this.service = service;
    }

    @Override
    public final String getHostType() {
        return "Cognos Portal";
    }

    private PortalItem[] getCached(String path) {
        return (PortalItem[])this.cacheSourcePath.get(path);
    }

    @Override
    public boolean isCached(String path) {
        return this.cacheSourcePath.containsKey(path);
    }

    public final void reset() {
        this.cacheSourcePath.clear();
    }

    @Override
    public Object connect(String path) throws IOException {
        return this.getPortalItem(path);
    }

    @Override
    public Hashtable describe(String path) throws IOException {
        PortalItem pi = this.getPortalItem(path);
        if (pi == null) {
            return EMPTY;
        }
        Hashtable<String, Object> t = new Hashtable<String, Object>();
        t.put("sourcepath", pi.sourcePath);
        t.put("cmpath", pi.cmPath);
        t.put("type", new Integer(pi.itemType));
        t.put("label", pi.label);
        return t;
    }

    public static String getName(String path) {
        String[] s = CMStringHelper.split(path, '/', false);
        if (s.length == 0) {
            return path;
        }
        return s[s.length - 1];
    }

    @Override
    public String getParent(String path) {
        return CMPathHelper.getParent(path);
    }

    private String[] render(PortalItem[] pi) {
        String[] r = new String[pi.length];
        for (int i = 0; i < pi.length; ++i) {
            String n = PortalSystem.getName(pi[i].sourcePath);
            r[i] = pi[i].itemType != 51 ? n + "/" : n;
        }
        return r;
    }

    @Override
    public String[] listRoots() throws IOException {
        return this.list("/", false);
    }

    public PortalItem[] listAsPortalItems(String path) {
        if (CMPathHelper.isFile(path)) {
            return new PortalItem[]{this.getPortalItem(path)};
        }
        return this.getCached(path);
    }

    public PortalItem getPortalItem(String path) {
        String parent = this.getParent(path);
        PortalItem[] pi = this.getCached(parent);
        if (pi == null) {
            return null;
        }
        for (int i = 0; i < pi.length; ++i) {
            if (!(pi[i].itemType != 51 ? path.equals(pi[i].sourcePath + "/") : path.equals(pi[i].sourcePath))) continue;
            return pi[i];
        }
        return null;
    }

    @Override
    public String[] list(String path) throws IOException {
        return this.list(path, false);
    }

    public String[] list(String path, boolean refresh) throws IOException {
        try {
            if (!this.isCached(path) || refresh) {
                if (path.equals("/")) {
                    PortalItem[] pi = this.service.browsePortal("", ITaskMonitor.NULL);
                    this.cacheSourcePath.put(path, pi);
                } else {
                    this.cacheSourcePath.put(path, this.service.browsePortal(path, ITaskMonitor.NULL));
                }
            }
            return this.render(this.getCached(path));
        }
        catch (CMException cme) {
            throw new IOException(cme.toString());
        }
    }
}

