/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client;

import com.cognos.mobile.client.IResourceExplorer;
import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMPathHelper;
import com.cognos.mobile.common.CMStringHelper;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.prompts.PTree;
import com.cognos.mobile.prompts.TreePromptNode;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public final class TreePromptSystem
implements IResourceExplorer {
    private static final Hashtable EMPTY = new Hashtable(0);
    private final Hashtable cacheSourcePath = new Hashtable();
    private final PTree tree;
    private final String conversation;
    private final MobileServiceProxy service;

    public TreePromptSystem(MobileServiceProxy service, PTree tree, String conversation) {
        this.service = service;
        this.tree = tree;
        this.conversation = conversation;
    }

    @Override
    public final String getHostType() {
        return "Tree Prompt";
    }

    private TreePromptNode[] getCached(String path) {
        return (TreePromptNode[])this.cacheSourcePath.get(path);
    }

    @Override
    public boolean isCached(String path) {
        return this.cacheSourcePath.containsKey(path);
    }

    public final void reset() {
        this.cacheSourcePath.clear();
    }

    @Override
    public Object connect(String path) throws IOException {
        return this.getTreePromptNode(path);
    }

    @Override
    public Hashtable describe(String path) throws IOException {
        TreePromptNode pi = this.getTreePromptNode(path);
        if (pi == null) {
            return EMPTY;
        }
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("displayValue", pi.getDisplayValue());
        t.put("useValue", pi.getUseValue());
        return t;
    }

    public static String getName(String path) {
        String[] s = CMStringHelper.split(path, '/', false);
        if (s.length == 0) {
            return path;
        }
        return s[s.length - 1];
    }

    @Override
    public String getParent(String path) {
        String p = CMPathHelper.getParent(path);
        if (p.length() > 1 && p.endsWith("/")) {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    private String render(TreePromptNode pi) {
        return pi.getDisplayValue();
    }

    private String[] render(TreePromptNode[] pi) {
        String[] r = new String[pi.length];
        for (int i = 0; i < pi.length; ++i) {
            r[i] = this.render(pi[i]);
        }
        return r;
    }

    @Override
    public String[] listRoots() throws IOException {
        return this.list("/", false);
    }

    @Override
    public String[] list(String path) throws IOException {
        System.out.println("listing path: " + path);
        return this.list(path, false);
    }

    public TreePromptNode getTreePromptNode(String path) {
        String parent = this.getParent(path);
        System.out.println("parent: " + parent);
        TreePromptNode[] pi = this.getCached(parent);
        if (pi == null) {
            return null;
        }
        String displayValue = CMPathHelper.getPathFname(path);
        for (int i = 0; i < pi.length; ++i) {
            if (!displayValue.equals(pi[i].getDisplayValue())) continue;
            return pi[i];
        }
        return null;
    }

    public TreePromptNode[] listAsNodes(String path, boolean refresh) throws IOException {
        try {
            if (!this.isCached(path) || refresh) {
                if (path.equals("/")) {
                    Vector v = this.tree.getRoots();
                    TreePromptNode[] tnp = new TreePromptNode[v.size()];
                    for (int i = 0; i < v.size(); ++i) {
                        tnp[i] = (TreePromptNode)v.elementAt(i);
                    }
                    System.out.println("putting path: " + path);
                    this.cacheSourcePath.put(path, tnp);
                } else {
                    TreePromptNode node = this.getTreePromptNode(path);
                    if (node != null) {
                        node = this.service.browseTreeNodePrompt(this.tree, node, this.conversation, null);
                        Vector v = node.getChildren();
                        TreePromptNode[] tnp = new TreePromptNode[v.size()];
                        for (int i = 0; i < v.size(); ++i) {
                            tnp[i] = (TreePromptNode)v.elementAt(i);
                        }
                        System.out.println("putting path: " + path);
                        this.cacheSourcePath.put(path, tnp);
                    }
                }
            }
            return this.getCached(path);
        }
        catch (CMException cme) {
            throw new IOException(cme.toString());
        }
    }

    public String[] list(String path, boolean refresh) throws IOException {
        try {
            if (!this.isCached(path) || refresh) {
                if (path.equals("/")) {
                    Vector v = this.tree.getRoots();
                    TreePromptNode[] tnp = new TreePromptNode[v.size()];
                    for (int i = 0; i < v.size(); ++i) {
                        tnp[i] = (TreePromptNode)v.elementAt(i);
                    }
                    System.out.println("putting path: " + path);
                    this.cacheSourcePath.put(path, tnp);
                } else {
                    TreePromptNode node = this.getTreePromptNode(path);
                    if (node != null) {
                        node = this.service.browseTreeNodePrompt(this.tree, node, this.conversation, null);
                        Vector v = node.getChildren();
                        TreePromptNode[] tnp = new TreePromptNode[v.size()];
                        for (int i = 0; i < v.size(); ++i) {
                            tnp[i] = (TreePromptNode)v.elementAt(i);
                        }
                        System.out.println("putting path: " + path);
                        this.cacheSourcePath.put(path, tnp);
                    }
                }
            }
            return this.render(this.getCached(path));
        }
        catch (CMException cme) {
            throw new IOException(cme.toString());
        }
    }
}

