/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client.tasks;

import com.cognos.mobile.client.tasks.BaseCommand;
import com.cognos.mobile.client.tasks.CommandRegistry;
import com.cognos.mobile.common.ISelectListener;
import com.cognos.mobile.common.ISelectSource;

public class CommandManager
implements ISelectListener {
    private BaseCommand[] commands = new BaseCommand[0];
    private final CommandRegistry cf;
    private int last = Integer.MIN_VALUE;
    private Object selected;

    public CommandManager(CommandRegistry cf) {
        this.cf = cf;
    }

    public final void setCurrentState(int state) {
        this.last = state;
    }

    public final int getCurrentState() {
        return this.last;
    }

    public final CommandRegistry getCommandRegistry() {
        return this.cf;
    }

    private final void updateCommands(Object src, int state) {
        if (this.getCurrentState() == state) {
            return;
        }
        BaseCommand[] rc = this.cf.getCommands(state);
        BaseCommand[] removals = new BaseCommand[this.commands.length];
        BaseCommand[] additions = new BaseCommand[rc.length];
        boolean addit = true;
        int additionsSize = 0;
        for (int i = 0; i < rc.length; ++i) {
            for (int j = 0; j < this.commands.length; ++j) {
                if (this.commands[j] != rc[i]) continue;
                addit = false;
                break;
            }
            if (addit) {
                additions[additionsSize++] = rc[i];
            }
            addit = true;
        }
        boolean keepit = false;
        int removalsSize = 0;
        for (int i = 0; i < this.commands.length; ++i) {
            for (int j = 0; j < rc.length; ++j) {
                if (this.commands[i] != rc[j]) continue;
                keepit = true;
                break;
            }
            if (!keepit) {
                removals[removalsSize++] = this.commands[i];
            }
            keepit = false;
        }
        this.addCommands(src, additions, additionsSize);
        this.removeCommands(src, removals, removalsSize);
        BaseCommand def = this.cf.getDefaultCommand(this.selected);
        if (def != null) {
            this.setDefaultCommand(src, def);
        } else {
            this.setDefaultCommand(src, null);
        }
        this.commands = rc;
    }

    public void addCommands(Object src, BaseCommand[] rc, int size) {
        for (int i = 0; i < size; ++i) {
            if (rc[i] == null) continue;
            rc[i].addToUI(src);
        }
    }

    public void removeCommands(Object src, BaseCommand[] rc, int size) {
        for (int i = 0; i < size; ++i) {
            if (rc[i] == null) continue;
            rc[i].removeFromUI(src);
        }
    }

    public final BaseCommand[] getActiveCommands() {
        return this.commands;
    }

    public void setDefaultCommand(Object src, BaseCommand c) {
        if (!(src instanceof ISelectSource)) {
            return;
        }
        ISelectSource disp = (ISelectSource)src;
        if (c == null) {
            disp.setSelectListener(ISelectListener.EMPTY);
            return;
        }
        if (c instanceof ISelectListener) {
            disp.setSelectListener((ISelectListener)((Object)c));
        }
    }

    @Override
    public void selected(Object src, Object o) {
        this.selected = o;
        int current = this.cf.getState(this.selected);
        this.updateCommands(src, current);
        this.setCurrentState(current);
    }
}

