/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client.tasks;

import com.cognos.mobile.client.tasks.BaseCommand;
import com.cognos.mobile.client.tasks.ITaskmaster;
import com.cognos.mobile.client.tasks.TaskMeta;
import java.util.Hashtable;

public class CommandRegistry {
    private final ITaskmaster taskmaster;
    private final Hashtable commands = new Hashtable();
    private final Hashtable commandsForMaskCache = new Hashtable();

    public CommandRegistry(ITaskmaster taskmaster) {
        this.taskmaster = taskmaster;
    }

    public void register(BaseCommand command) {
        this.commands.put(command.getTask(), command);
    }

    public void clear() {
        this.commands.clear();
        this.commandsForMaskCache.clear();
    }

    public BaseCommand getDefaultCommand(Object o) {
        int t = this.taskmaster.defaultTaskForState(o);
        if (t == -1) {
            return null;
        }
        TaskMeta task = this.taskmaster.createTaskMeta(t);
        return (BaseCommand)this.commands.get(task);
    }

    public int getState(Object o) {
        return this.taskmaster.tasksForState(o);
    }

    public BaseCommand[] getCommands(int mask) {
        Integer key = new Integer(mask);
        if (this.commandsForMaskCache.contains(key)) {
            return (BaseCommand[])this.commandsForMaskCache.get(key);
        }
        TaskMeta[] t = this.taskmaster.taskMetasForMask(mask);
        BaseCommand[] result = new BaseCommand[t.length];
        for (int i = 0; i < t.length; ++i) {
            result[i] = (BaseCommand)this.commands.get(t[i]);
        }
        this.commandsForMaskCache.put(key, result);
        return result;
    }
}

