/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client.tasks;

import com.cognos.mobile.client.IClientApplication;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.location.LocationServices;
import com.cognos.mobile.vm.VM;
import com.cognos.mobile.vm.VMOptions;

public class GPSWarmUpTask
implements Runnable {
    private static Class CLASS = GPSWarmUpTask.class;
    private int lastAnswer = -1;
    private int lastOption = -1;
    private int lastUseLocation = -1;
    private final VMOptions options;
    private final IClientApplication client;
    private final LocationServices locationService;
    private final IResourceManager resManager;

    public GPSWarmUpTask(VMOptions options, IClientApplication client, LocationServices locationService, IResourceManager resManager) {
        this.options = options;
        this.client = client;
        this.locationService = locationService;
        this.resManager = resManager;
    }

    public boolean gpsOptionChanged() {
        return this.lastOption != this.options.getGPSAlwaysOn() || this.options.getUseLocation() != this.lastUseLocation;
    }

    private boolean gpsWarmUpEnabled() {
        if (!this.locationService.showUseLocationUIOnOptionsPage()) {
            VM.log(CLASS, 0, "location-awareness is not supported by device or disabled on server.");
            return false;
        }
        if (this.options.getUseLocation() == 0) {
            VM.log(CLASS, 0, "location-awareness is disabled on device.");
            return false;
        }
        return true;
    }

    public boolean sendLocationRequestNeeded() {
        if (!this.options.isHotGPSEnabled()) {
            return false;
        }
        this.lastOption = this.options.getGPSAlwaysOn();
        this.lastUseLocation = this.options.getUseLocation();
        if (!this.gpsWarmUpEnabled()) {
            return false;
        }
        if (this.options.getGPSAlwaysOn() == 1) {
            this.lastAnswer = this.client.askYesNoQuestion(this.resManager.loadString(CMIDs.OPTIONS_GPS_ALWAY_ON), this.resManager.loadString(CMIDs.LOCATION_GPS_ALWAYS_ON));
            return this.lastAnswer == 1;
        }
        return this.options.getGPSAlwaysOn() == 2;
    }

    @Override
    public void run() {
        try {
            VM.log(CLASS, 3, "Start to send location warm-up request...");
            this.locationService.getLocation();
            VM.log(CLASS, 3, "The location warm-up request sent successfully!");
        }
        catch (Throwable e) {
            VM.log(CLASS, 3, e);
        }
    }
}

