/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client.tasks;

import com.cognos.mobile.client.tasks.BaseTaskmaster;
import com.cognos.mobile.client.tasks.TaskMeta;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.inbox.IInboxSource;
import com.cognos.mobile.model.data.Render;
import com.cognos.mobile.vm.InboxItem;
import com.cognos.mobile.vm.VMInbox;
import com.cognos.mobile.vm.VMOptions;

public class InboxScreenTaskmaster
extends BaseTaskmaster {
    public static final int TASK_LOG_ON = 2;
    public static final int TASK_LOG_OFF = 4;
    public static final int TASK_OPTIONS = 8;
    public static final int TASK_ABOUT = 16;
    public static final int TASK_CLOSE = 32;
    public static final int TASK_EXIT_DEMO_INBOX = 64;
    public static final int TASK_EXIT = 128;
    public static final int TASK_BROWSE_PORTAL = 512;
    public static final int TASK_BROWSE_FILESYSTEM = 1024;
    public static final int TASK_REFRESH_INBOX = 2048;
    public static final int TASK_DELETE_ALL = 4096;
    public static final int TASK_DELETE = 16384;
    public static final int TASK_MARK_READ = 65536;
    public static final int TASK_MARK_UNREAD = 131072;
    public static final int TASK_MARK_ALL_READ = 262144;
    public static final int TASK_OPEN_ITEMS = 0x100000;
    public static final int TASK_SEARCH = 0x200000;
    public static final int TASK_SET_AS_DASHBOARD = 0x4000000;
    public static final int TASK_REMOVE_DASHBOARD = 0x8000000;
    public static final int TASK_HTML_HELP = 0x10000000;
    public static final int TASK_RERUN_REPORT = 0x20000000;
    public static final int TASK_SET_AS_FAVOURITE = 0x40000000;
    public static final int TASK_REMOVE_FAVOURITE = Integer.MIN_VALUE;
    private final VMOptions options;
    private final VMInbox inbox;
    protected final IResourceManager resourceManager;

    public InboxScreenTaskmaster(IResourceManager resourceManager, VMOptions options, VMInbox inbox) {
        this.options = options;
        this.inbox = inbox;
        this.resourceManager = resourceManager;
    }

    @Override
    public TaskMeta createTaskMeta(int id) {
        switch (id) {
            case 0x20000000: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.DETAILS_MENU_RUN_REPORT), null);
            }
            case 2: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_LOG_ON), null);
            }
            case 4: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_LOG_OFF), null);
            }
            case 8: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_OPTIONS), null);
            }
            case 16: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_ABOUT), null);
            }
            case 0x10000000: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_HELP), null);
            }
            case 32: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_CLOSE), null);
            }
            case 64: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_EXIT_DEMO_INBOX), null);
            }
            case 128: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_EXIT), null);
            }
            case 512: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_BROWSE), null);
            }
            case 1024: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_BROWSE_FILESYSTEM), null);
            }
            case 2048: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_REFRESH_INBOX), null);
            }
            case 4096: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_DELETE_ALL), null);
            }
            case 16384: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_DELETE), null);
            }
            case 65536: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_MARK_READ), null);
            }
            case 131072: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_MARK_UNREAD), null);
            }
            case 262144: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_MARK_ALL_READ), null);
            }
            case 0x100000: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_OPEN), null);
            }
            case 0x200000: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_SEARCH), null);
            }
            case 0x4000000: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_SET_WELCOME), null);
            }
            case 0x8000000: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_REMOVE_WELCOME), null);
            }
            case 0x40000000: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_SET_FAVOURITE), null);
            }
            case -2147483648: {
                return new TaskMeta(id, this.resourceManager.loadString(CMIDs.MENU_REMOVE_FAVOURITE), null);
            }
        }
        return null;
    }

    @Override
    public int defaultTaskForState(Object item) {
        if (item != null) {
            return 0x100000;
        }
        switch (this.options.getAuthenticationState()) {
            default: {
                return 2048;
            }
            case 0: 
        }
        return 2;
    }

    @Override
    public int tasksForState(Object o) {
        int authenticationMode = this.options.getAuthenticationState();
        int result = 0;
        if (o != null) {
            Render r = (Render)o;
            InboxItem[] items = this.inbox.getItems();
            InboxItem item = null;
            int index = -1;
            for (int i = 0; i < items.length; ++i) {
                if (items[i].getMetadata().renderID != r.renderID) continue;
                item = items[i];
                index = i;
                break;
            }
            if (item != null) {
                InboxItem dashboardItem;
                int itemFlags = item.getFlags();
                result |= 0x20100000;
                result = (itemFlags & 2) > 0 ? (result |= 0x20000) : (result |= 0x10000);
                if (this.inbox.hasUnopenedRenders() && items.length > 1) {
                    result |= 0x40000;
                }
                result = (dashboardItem = this.inbox.getWelcomeItem(this.options)) != null && item.getMetadata().renderID == dashboardItem.getMetadata().renderID ? (result |= 0x8000000) : (result |= 0x4000000);
                result |= 0x40000000;
                if (authenticationMode != 3) {
                    result |= 0x4000;
                    if (items.length > 1) {
                        result |= 0x1000;
                    }
                }
            }
        }
        result |= 0x98;
        if (this.options.getServerUrl() != null && this.options.getServerUrl().length() != 0) {
            result |= 0x10000000;
        }
        switch (authenticationMode) {
            case 0: {
                break;
            }
            case 2: {
                result |= 4;
            }
            case 1: {
                result |= 0x200200;
                IInboxSource inboxSource = this.inbox.getInboxSource();
                if (inboxSource == null) break;
                result |= 0x800;
                break;
            }
        }
        if (authenticationMode != 3) {
            result |= 2;
        }
        return result;
    }
}

