/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.client.tasks;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.MobileServiceProxy;
import com.cognos.mobile.event.Event;
import com.cognos.mobile.event.IEventManager;
import com.cognos.mobile.model.data.Report;
import com.cognos.mobile.task.IMonitorableTask;
import com.cognos.mobile.task.ITaskMonitor;
import com.cognos.mobile.vm.VM;

public class SearchReportTask
implements IMonitorableTask {
    private static Class CLASS = SearchReportTask.class;
    private final MobileServiceProxy serverManager;
    private final IEventManager eventManager;
    private final String keyword;

    public SearchReportTask(MobileServiceProxy serverManager, IEventManager eventManager, String keyword) {
        this.serverManager = serverManager;
        this.eventManager = eventManager;
        this.keyword = keyword;
    }

    @Override
    public String getInitialText1ID() {
        return CMIDs.SEARCH_1;
    }

    @Override
    public String getInitialText2ID() {
        return CMIDs.SEARCH_2;
    }

    @Override
    public String getInitialButtonTextID() {
        return CMIDs.SEARCH_BUTTON;
    }

    @Override
    public Object run(ITaskMonitor taskMonitor) throws CMException {
        VM.log(CLASS, 1, "searching reports...");
        Report[] reports = this.serverManager.search(this.keyword, taskMonitor);
        VM.log(CLASS, 1, "search " + reports.length + " reports(s)");
        this.eventManager.postEvent(new Event(this, 4, reports));
        return reports;
    }
}

