/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.CMStringHelper;

public class C8 {
    public static final int ITEMTYPE_NULL = 50;
    public static final int ITEMTYPE_REPORT = 51;
    public static final int ITEMTYPE_QUERY = 52;
    public static final int ITEMTYPE_ANALYSIS = 53;
    public static final int ITEMTYPE_REPORTVIEW = 54;
    public static final int ITEMTYPE_SHORTCUT = 55;
    public static final int ITEMTYPE_DASHBOARD = 56;
    public static final int ITEMTYPE_ACTIVEREPORT = 57;
    public static final int ITEMTYPE_FOLDER = 58;
    public static final int ITEMTYPE_PACKAGE = 59;
    public static final int ITEMTYPE_SECUREDFUNCTION = 60;
    public static final int ITEMTYPE_DATASOURCE_CONNECTION = 61;
    public static final int ITEMTYPE_DASHBOARD_WIDGET = 62;
    public static final int ITEMTYPE_SKIN = 63;
    public static final int ITEMTYPE_CONTENT = 64;
    public static final int ITEMTYPE_ACTIVEREPORTVIEW = 65;
    public static final int ITEMTYPE_OFFSET = 50;
    public static final String[] C8_SUPPORTED_OBJECT_TYPE = new String[]{"report", "query", "analysis", "reportView", "shortcut", "dashboard", "interactiveReport"};

    public static class PortalItem {
        public static final String EXECUTE_PERMISSION = "execute";
        public static final String READ_PERMISSION = "read";
        public String defaultName;
        public String cmPath;
        public String modificationTime;
        public String targetCMPath;
        public String sourcePath;
        public int itemType;
        public int shortcutType;
        public String storeID;
        public String[] permissions;
        public boolean prompt = true;
        public String defaultDescription;
        public boolean isHidden;

        public PortalItem() {
            this.shortcutType = 50;
            this.itemType = 50;
        }

        public PortalItem(PortalItem other) {
            this.cmPath = other.cmPath;
            this.defaultName = other.defaultName;
            this.itemType = other.itemType;
            this.shortcutType = other.shortcutType;
            this.modificationTime = other.modificationTime;
            this.permissions = other.permissions;
            this.prompt = other.prompt;
            this.sourcePath = other.sourcePath;
            this.storeID = other.storeID;
            this.targetCMPath = other.targetCMPath;
        }

        public String[] removePermission(String permission) {
            if (this.permissions == null) {
                return null;
            }
            String[] output = new String[this.permissions.length - 1];
            int count = 0;
            for (String i : this.permissions) {
                if (i.equals(permission)) continue;
                output[count++] = i;
            }
            return output;
        }

        public boolean hasPermission(String permissionWanted) {
            if (this.permissions == null) {
                return false;
            }
            for (int i = 0; i < this.permissions.length; ++i) {
                if (!this.permissions[i].equals(permissionWanted)) continue;
                return true;
            }
            return false;
        }

        public int getSupportedItemType() {
            return this.itemType;
        }

        public boolean isSupportedType() {
            return this.getSupportedItemType() != 50;
        }

        static String getTypeFromSearchPath(String searchPath) throws CMException {
            int startIdx;
            int endIdx;
            if (searchPath == null || searchPath.length() == 0) {
                throw new CMException(1160, "Cannot infer object type from search path: " + searchPath);
            }
            searchPath = searchPath.trim();
            String attrName = "[@name=\"";
            if (searchPath.endsWith("']")) {
                attrName = "[@name='";
            }
            if ((endIdx = CMStringHelper.lastIndexOf(searchPath, attrName)) > 0 && (startIdx = searchPath.lastIndexOf(47, endIdx)) > 0) {
                return searchPath.substring(startIdx + 1, endIdx);
            }
            throw new CMException(1160, "Cannot infer object type from search path: " + searchPath);
        }

        static int getItemType(String objectType) throws CMException {
            if (objectType == null || objectType.length() == 0) {
                throw new CMException(1160, "Cannot infer item type from objectType: " + objectType);
            }
            for (int i = 0; i < C8_SUPPORTED_OBJECT_TYPE.length; ++i) {
                if (!objectType.equals(C8_SUPPORTED_OBJECT_TYPE[i])) continue;
                return i + 50 + 1;
            }
            if (objectType.equals("folder")) {
                return 58;
            }
            if (objectType.equals("package")) {
                return 59;
            }
            return 50;
        }

        public void handleShortcut() throws CMException {
            String objectType;
            this.shortcutType = 50;
            if (this.itemType == 55 && PortalItem.getItemType(objectType = PortalItem.getTypeFromSearchPath(this.targetCMPath)) != 50) {
                this.shortcutType = 55;
            }
        }
    }
}

