/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.ILogger;

public class CMCircularLogger
implements ILogger {
    private final StringBuffer[] a;
    private int current = 0;
    private int flags;
    public static int FLAG_NONE = 0;
    public static int FLAG_SEPARATORS = 1;
    public static int FLAG_NEWLINES = 2;

    public CMCircularLogger(int ringSize, int flags) {
        this.a = new StringBuffer[ringSize];
        this.a[this.current] = new StringBuffer();
        this.flags = flags;
    }

    @Override
    public void log(String s) {
        this.a[this.current].append(s);
    }

    @Override
    public void log(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 32 && b[i] <= 126) {
                this.a[this.current].append((char)b[i]);
                continue;
            }
            this.a[this.current].append('.');
        }
    }

    @Override
    public void next() {
        ++this.current;
        if (this.current >= this.a.length) {
            this.current = 0;
        }
        this.a[this.current] = new StringBuffer();
    }

    @Override
    public void dump(StringBuffer sb) {
        for (int i = 0; i < this.a.length; ++i) {
            int j = (i + this.current + 1) % this.a.length;
            if (this.a[j] == null) continue;
            if ((this.flags & FLAG_SEPARATORS) != 0) {
                sb.append("-------\n");
            }
            sb.append(this.a[j]);
            if ((this.flags & FLAG_NEWLINES) == 0) continue;
            sb.append("\n");
        }
    }

    public int getRingSize() {
        return this.a.length;
    }
}

