/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.ICMCommandLineHost;

public class CMCommandLine {
    private ICMCommandLineHost m_host;
    private int m_minSeverity = 3;

    public CMCommandLine(ICMCommandLineHost host) {
        this.m_host = host;
    }

    public boolean parseArguments(Object context, String[] args) {
        if (null == args || args.length == 0) {
            this.m_host.onCommandLineHelp(context);
            return false;
        }
        int i = 0;
        while (i < args.length) {
            int rc;
            if (args[i] == null || args[i].equals("")) continue;
            switch (args[i].charAt(0)) {
                case '-': {
                    String flag = args[i].substring(1).trim();
                    if (flag.equals("")) {
                        rc = this.m_host.onCommandLineParseParameter(context, args[i]);
                        break;
                    }
                    String nextArg = i + 1 < args.length ? args[i + 1] : null;
                    rc = this.parseStandardFlags(context, flag, nextArg);
                    if (rc > 0) break;
                    rc = this.m_host.onCommandLineParseFlag(context, flag, nextArg);
                    break;
                }
                default: {
                    rc = this.m_host.onCommandLineParseParameter(context, args[i]);
                }
            }
            if (rc == 0) {
                System.err.println("failed to process argument: " + args[i]);
                this.m_host.onCommandLineHelp(context);
                return false;
            }
            if (rc < 0) {
                return false;
            }
            i += rc;
        }
        return true;
    }

    public int getMinSeverity() {
        return this.m_minSeverity;
    }

    private int parseStandardFlags(Object context, String flag, String nextArg) {
        int rc = 0;
        if (flag.equals("h")) {
            this.m_host.onCommandLineHelp(context);
            rc = 1;
        } else if (flag.equals("q")) {
            this.m_minSeverity = 4;
            rc = 1;
        } else if (flag.equals("v0")) {
            this.m_minSeverity = 3;
            rc = 1;
        } else if (flag.equals("v1")) {
            this.m_minSeverity = 2;
            rc = 1;
        } else if (flag.equals("v2")) {
            this.m_minSeverity = 1;
            rc = 1;
        } else if (flag.equals("v3")) {
            this.m_minSeverity = 0;
            rc = 1;
        }
        return rc;
    }
}

