/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMException;
import com.cognos.mobile.common.ICMImageFactory;
import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.VMPoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class CMCompositeImage
implements IVMImage {
    static final byte FORMAT = 4;
    private Hashtable m_images;
    private Hashtable m_blankImageCache;
    private int m_tileSize;
    private int m_numRows;
    private int m_numColumns;
    private VMPoint m_size;
    private final ICMImageFactory m_imageFactory;

    public CMCompositeImage(ICMImageFactory imageFactory) {
        this.m_imageFactory = imageFactory;
    }

    public CMCompositeImage(ICMImageFactory imageFactory, DataInputStream din) throws IOException {
        this.m_imageFactory = imageFactory;
        this.onSerializableLoad(din);
    }

    public CMCompositeImage(ICMImageFactory imageFactory, int width, int height, int tileSize) {
        this.m_imageFactory = imageFactory;
        this.init(width, height, tileSize);
    }

    protected void setSize(VMPoint size) {
        this.m_size = size;
    }

    public final int getTileSize() {
        return this.m_tileSize;
    }

    @Override
    public final VMPoint onImageGetSize() {
        return this.m_size;
    }

    protected ICMImageFactory getImageFactory() {
        return this.m_imageFactory;
    }

    protected synchronized void init(int width, int height, int tileSize) {
        this.setSize(new VMPoint(width, height));
        this.m_tileSize = tileSize;
        this.m_numColumns = (int)Math.ceil((double)width / (double)tileSize);
        this.m_numRows = (int)Math.ceil((double)height / (double)tileSize);
        this.m_images = this.initTiles();
    }

    private Hashtable initTiles() {
        Hashtable<VMPoint, IVMImage> images = new Hashtable<VMPoint, IVMImage>();
        for (int x = 0; x < this.getNumColumns(); ++x) {
            for (int y = 0; y < this.getNumRows(); ++y) {
                VMPoint dim = this.calcTileSize(x, y);
                images.put(new VMPoint(x, y), this.createBlankImage(dim.x, dim.y));
            }
        }
        return images;
    }

    private VMPoint calcTileSize(int x, int y) {
        if (x >= 0 && x < this.getNumColumns() && y >= 0 && y < this.getNumRows()) {
            int width = this.m_tileSize;
            if (x * this.m_tileSize + this.m_tileSize > this.onImageGetSize().x) {
                width = this.onImageGetSize().x % this.m_tileSize;
            }
            int height = this.m_tileSize;
            if (y * this.m_tileSize + this.m_tileSize > this.onImageGetSize().y) {
                height = this.onImageGetSize().y % this.m_tileSize;
            }
            return new VMPoint(width, height);
        }
        throw new IllegalArgumentException("Tile doesn't exist at (" + x + ", " + y + ")");
    }

    public final int getNumRows() {
        return this.m_numRows;
    }

    public final int getNumColumns() {
        return this.m_numColumns;
    }

    private synchronized Hashtable getBlankImageCache() {
        if (this.m_blankImageCache == null) {
            this.m_blankImageCache = new Hashtable(3);
        }
        return this.m_blankImageCache;
    }

    private synchronized IVMImage createBlankImage(int w, int h) {
        VMPoint p = new VMPoint(w, h);
        if (this.getBlankImageCache().contains(p)) {
            return (IVMImage)this.getBlankImageCache().get(p);
        }
        try {
            IVMImage blank = this.getImageFactory().create(w, h);
            this.getBlankImageCache().put(p, blank);
            return blank;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Can't create blank image from imageFactory: " + ioe.toString());
        }
    }

    @Override
    public final synchronized void onImageDispose() {
        IVMImage im;
        VMPoint p;
        Enumeration enm = this.m_images.keys();
        while (enm.hasMoreElements()) {
            p = (VMPoint)enm.nextElement();
            im = (IVMImage)this.m_images.get(p);
            if (im == null) continue;
            im.onImageDispose();
        }
        this.m_images.clear();
        enm = this.getBlankImageCache().keys();
        while (enm.hasMoreElements()) {
            p = (VMPoint)enm.nextElement();
            im = (IVMImage)this.getBlankImageCache().get(p);
            if (im == null) continue;
            im.onImageDispose();
        }
        this.getBlankImageCache().clear();
    }

    protected synchronized IVMImage get(int x, int y) {
        return (IVMImage)this.m_images.get(new VMPoint(x, y));
    }

    public final synchronized void set(int tileX, int tileY, IVMImage image) {
        IVMImage old = (IVMImage)this.m_images.get(new VMPoint(tileX, tileY));
        if (old == null) {
            throw new IllegalArgumentException("Tile doesn't exist at (" + tileX + ", " + tileY + ")");
        }
        if (image != null) {
            this.m_images.put(new VMPoint(tileX, tileY), image);
            old.onImageDispose();
        }
    }

    @Override
    public abstract void onImageGetRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    @Override
    public abstract void onImageSetRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onSerializableSave(DataOutputStream out) throws IOException {
        Hashtable hashtable = this.m_images;
        synchronized (hashtable) {
            out.writeByte(4);
            out.writeInt(this.onImageGetSize().x);
            out.writeInt(this.onImageGetSize().y);
            out.writeInt(this.m_tileSize);
            for (int x = 0; x < this.getNumColumns(); ++x) {
                for (int y = 0; y < this.getNumRows(); ++y) {
                    IVMImage img = this.get(x, y);
                    img.onSerializableSave(out);
                }
            }
        }
    }

    @Override
    public final synchronized void onSerializableLoad(DataInputStream in) throws IOException {
        int width = in.readInt();
        int height = in.readInt();
        int tileSize = in.readInt();
        this.init(width, height, tileSize);
        for (int x = 0; x < this.getNumColumns(); ++x) {
            for (int y = 0; y < this.getNumRows(); ++y) {
                this.set(x, y, this.m_imageFactory.create(in));
            }
        }
    }

    @Override
    public abstract void onImageSaveEncodedImage(int var1, OutputStream var2) throws CMException;
}

