/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMIDs;
import com.cognos.mobile.common.IResourceManager;
import com.cognos.mobile.common.MobileException;
import java.util.Locale;

public class CMException
extends Exception
implements MobileException {
    private static final long serialVersionUID = 5611353556249542564L;
    private int m_errorCode;
    private String[] m_params;
    private Object arg;
    private Object attachedArg;
    private Locale m_contentLocale;

    public CMException(int errorCode, Object arg) {
        this(errorCode, null, null, null);
        this.arg = arg;
    }

    public CMException(int errorCode) {
        this(errorCode, null, null, null);
    }

    public CMException(int errorCode, String[] params) {
        this(errorCode, params, null, null);
    }

    public CMException(int errorCode, String details) {
        this(errorCode, null, details, null);
    }

    public CMException(int errorCode, String details, Locale locale) {
        this(errorCode, null, details, null, locale);
    }

    public CMException(int errorCode, String[] params, String details) {
        this(errorCode, params, details, null);
    }

    public CMException(int errorCode, Throwable ex) {
        this(errorCode, null, null, ex);
    }

    public CMException(int errorCode, String[] params, Throwable ex) {
        this(errorCode, params, null, ex);
    }

    public CMException(int errorCode, String details, Throwable t) {
        this(errorCode, null, details, t);
    }

    public CMException(int errorCode, String[] params, String details, Throwable t) {
        super(CMException.buildMessage(errorCode, params, details), t);
        this.m_errorCode = errorCode;
        this.m_params = params;
    }

    public CMException(int errorCode, String[] params, String details, Throwable t, Locale locale) {
        super(CMException.buildMessage(errorCode, params, details), t);
        this.m_errorCode = errorCode;
        this.m_params = params;
        this.m_contentLocale = locale;
    }

    public Locale getContentLocale() {
        return this.m_contentLocale;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    @Override
    public String[] getErrorParams() {
        return this.m_params;
    }

    @Override
    public final Object getArgument() {
        return this.arg;
    }

    public final void setAttachedArgument(Object obj) {
        this.attachedArg = obj;
    }

    public final Object getAttachedArgument() {
        return this.attachedArg;
    }

    public String getLocalizedMessage(IResourceManager resourceManager) {
        String message = resourceManager.formatString(Integer.toString(this.m_errorCode), this.m_params);
        if (message == null || message.length() == 0) {
            message = resourceManager.formatString(CMIDs.UNKNOWN_ERROR_CODE, Integer.toString(this.m_errorCode));
        }
        return message;
    }

    protected static String buildMessage(int errorCode, String[] params, String details) {
        StringBuffer sb = new StringBuffer();
        if (details != null) {
            sb.append(details);
        }
        sb.append(" (code ");
        sb.append(errorCode);
        if (params != null) {
            sb.append(" params '");
            String prefix = "";
            for (int i = 0; i < params.length; ++i) {
                sb.append(prefix);
                sb.append(params[i]);
                prefix = "', '";
            }
            sb.append("'");
        }
        sb.append(")");
        return sb.toString();
    }
}

