/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

public class CMFixedHelper {
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int ONE = 65536;
    public static final int HALF = 32768;

    public static int doubleToFixed(double d) {
        if (d > 32767.0) {
            return Integer.MAX_VALUE;
        }
        if (d < -32767.0) {
            return -2147483647;
        }
        return (int)(d * 65536.0 + (d < 0.0 ? -0.5 : 0.5));
    }

    public static double fixedToDouble(int fixed) {
        return (double)fixed / 65536.0;
    }

    public static int integerToFixed(int i) {
        return i << 16;
    }

    public static int fixedToInteger(int fixed) {
        return CMFixedHelper.floor(fixed) + ((fixed & 0x8000) >> 15);
    }

    public static int floor(int fixed) {
        if (fixed >= 0) {
            return fixed >> 16;
        }
        return ~(~fixed >> 16);
    }

    public static int ceil(int fixed) {
        if (fixed > 0x7FFF0000) {
            return Short.MAX_VALUE;
        }
        return CMFixedHelper.floor(fixed + 65535);
    }
}

