/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.common.CMStringHelper;
import java.util.Hashtable;

public class CMHtmlHelper {
    public static final int HTMLTAGTYPE_NOTAG = -1;
    public static final int HTMLTAGTYPE_REGULAR = 0;
    public static final int HTMLTAGTYPE_REMOVECONTENT = 1;
    public static final int HTMLTAGTYPE_COMMENT = 2;
    private static Hashtable supportedHTMLTags = null;
    private static String[] supportJSCmd = new String[]{"onclick", "ondblclick", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup"};

    public static int getHTMLTagType(String tagName) {
        Object tagType;
        if (supportedHTMLTags == null) {
            supportedHTMLTags = new Hashtable();
            supportedHTMLTags.put("!--", new Integer(2));
            supportedHTMLTags.put("a", new Integer(0));
            supportedHTMLTags.put("abbr", new Integer(0));
            supportedHTMLTags.put("acronym", new Integer(0));
            supportedHTMLTags.put("address", new Integer(0));
            supportedHTMLTags.put("applet", new Integer(0));
            supportedHTMLTags.put("area", new Integer(0));
            supportedHTMLTags.put("b", new Integer(0));
            supportedHTMLTags.put("base", new Integer(0));
            supportedHTMLTags.put("basefont", new Integer(0));
            supportedHTMLTags.put("bdo", new Integer(0));
            supportedHTMLTags.put("big", new Integer(0));
            supportedHTMLTags.put("blockquote", new Integer(0));
            supportedHTMLTags.put("body", new Integer(0));
            supportedHTMLTags.put("br", new Integer(0));
            supportedHTMLTags.put("button", new Integer(0));
            supportedHTMLTags.put("caption", new Integer(0));
            supportedHTMLTags.put("cdata", new Integer(0));
            supportedHTMLTags.put("center", new Integer(0));
            supportedHTMLTags.put("cite", new Integer(0));
            supportedHTMLTags.put("code", new Integer(0));
            supportedHTMLTags.put("col", new Integer(0));
            supportedHTMLTags.put("colgroup", new Integer(0));
            supportedHTMLTags.put("dd", new Integer(0));
            supportedHTMLTags.put("del", new Integer(0));
            supportedHTMLTags.put("dfn", new Integer(0));
            supportedHTMLTags.put("dir", new Integer(0));
            supportedHTMLTags.put("div", new Integer(0));
            supportedHTMLTags.put("dl", new Integer(0));
            supportedHTMLTags.put("DOCTYPE", new Integer(0));
            supportedHTMLTags.put("dt", new Integer(0));
            supportedHTMLTags.put("em", new Integer(0));
            supportedHTMLTags.put("fieldset", new Integer(0));
            supportedHTMLTags.put("font", new Integer(0));
            supportedHTMLTags.put("form", new Integer(0));
            supportedHTMLTags.put("h1", new Integer(0));
            supportedHTMLTags.put("h2", new Integer(0));
            supportedHTMLTags.put("h3", new Integer(0));
            supportedHTMLTags.put("h4", new Integer(0));
            supportedHTMLTags.put("h5", new Integer(0));
            supportedHTMLTags.put("h6", new Integer(0));
            supportedHTMLTags.put("head", new Integer(1));
            supportedHTMLTags.put("hr", new Integer(0));
            supportedHTMLTags.put("html", new Integer(0));
            supportedHTMLTags.put("i", new Integer(0));
            supportedHTMLTags.put("iframe", new Integer(0));
            supportedHTMLTags.put("img", new Integer(0));
            supportedHTMLTags.put("input", new Integer(0));
            supportedHTMLTags.put("ins", new Integer(0));
            supportedHTMLTags.put("isindex", new Integer(0));
            supportedHTMLTags.put("kbd", new Integer(0));
            supportedHTMLTags.put("label", new Integer(0));
            supportedHTMLTags.put("legend", new Integer(0));
            supportedHTMLTags.put("li", new Integer(0));
            supportedHTMLTags.put("link", new Integer(0));
            supportedHTMLTags.put("map", new Integer(0));
            supportedHTMLTags.put("menu", new Integer(0));
            supportedHTMLTags.put("meta", new Integer(1));
            supportedHTMLTags.put("mzscheme", new Integer(0));
            supportedHTMLTags.put("noframes", new Integer(0));
            supportedHTMLTags.put("noscript", new Integer(1));
            supportedHTMLTags.put("object", new Integer(0));
            supportedHTMLTags.put("ol", new Integer(0));
            supportedHTMLTags.put("optgroup", new Integer(0));
            supportedHTMLTags.put("option", new Integer(0));
            supportedHTMLTags.put("p", new Integer(0));
            supportedHTMLTags.put("param", new Integer(0));
            supportedHTMLTags.put("pcdata", new Integer(0));
            supportedHTMLTags.put("pre", new Integer(0));
            supportedHTMLTags.put("q", new Integer(0));
            supportedHTMLTags.put("s", new Integer(0));
            supportedHTMLTags.put("samp", new Integer(0));
            supportedHTMLTags.put("script", new Integer(1));
            supportedHTMLTags.put("select", new Integer(0));
            supportedHTMLTags.put("small", new Integer(0));
            supportedHTMLTags.put("span", new Integer(0));
            supportedHTMLTags.put("strike", new Integer(0));
            supportedHTMLTags.put("strong", new Integer(0));
            supportedHTMLTags.put("style", new Integer(1));
            supportedHTMLTags.put("sub", new Integer(0));
            supportedHTMLTags.put("sup", new Integer(0));
            supportedHTMLTags.put("table", new Integer(0));
            supportedHTMLTags.put("tbody", new Integer(0));
            supportedHTMLTags.put("td", new Integer(0));
            supportedHTMLTags.put("textarea", new Integer(0));
            supportedHTMLTags.put("tfoot", new Integer(0));
            supportedHTMLTags.put("th", new Integer(0));
            supportedHTMLTags.put("thead", new Integer(0));
            supportedHTMLTags.put("title", new Integer(0));
            supportedHTMLTags.put("tr", new Integer(0));
            supportedHTMLTags.put("tt", new Integer(0));
            supportedHTMLTags.put("u", new Integer(0));
            supportedHTMLTags.put("ul", new Integer(0));
            supportedHTMLTags.put("var", new Integer(0));
        }
        if ((tagType = supportedHTMLTags.get(tagName)) != null) {
            return (Integer)tagType;
        }
        return -1;
    }

    public static String stripHtml(String str) {
        if (str == null) {
            return null;
        }
        if ((str = CMHtmlHelper.stripJavaScript(str)).indexOf("<") == -1) {
            return str;
        }
        if (!CMHtmlHelper.hasHTMLTag(str)) {
            return str;
        }
        boolean checkTag = false;
        boolean isTag = false;
        boolean removeContent = false;
        boolean closingTag = false;
        boolean storedSlash = false;
        boolean commented = false;
        StringBuffer strippedStr = new StringBuffer();
        String[] htmlDelimiters = new String[]{"-->", "<", ">", "/"};
        String[] splitStr = CMStringHelper.split(str, htmlDelimiters, false, true);
        int tagType = -1;
        String line = null;
        for (int i = 0; i < splitStr.length; ++i) {
            line = splitStr[i];
            if (line == null) continue;
            if (line.equals("<")) {
                if (checkTag) {
                    strippedStr.append(splitStr[i - 1]);
                    checkTag = false;
                }
                if (isTag || commented) continue;
                checkTag = true;
                continue;
            }
            if (line.equals(">")) {
                if (commented) continue;
                if (isTag) {
                    isTag = false;
                    if (closingTag) {
                        if (removeContent && tagType == 1) {
                            removeContent = false;
                        }
                        closingTag = false;
                    }
                    storedSlash = false;
                } else {
                    if (i > 0 && splitStr[i - 1].charAt(0) == '<') {
                        strippedStr.append(splitStr[i - 1]);
                    }
                    strippedStr.append(">");
                }
                checkTag = false;
                continue;
            }
            if (line.equals("-->")) {
                if (removeContent) continue;
                if (isTag && commented) {
                    isTag = false;
                    storedSlash = false;
                } else {
                    strippedStr.append("-->");
                }
                checkTag = false;
                continue;
            }
            if (line.equals("/")) {
                storedSlash = true;
                if (checkTag || isTag) {
                    if (i + 1 >= splitStr.length || !CMHtmlHelper.isValidTag(splitStr[i + 1]) && !splitStr[i + 1].equals(">")) continue;
                    closingTag = true;
                    continue;
                }
                if (removeContent || commented) continue;
                strippedStr.append("/");
                continue;
            }
            if (checkTag) {
                String tagName = line.trim().toLowerCase();
                int spacePos = tagName.indexOf(32);
                if (spacePos >= 0) {
                    tagName = tagName.substring(0, spacePos);
                }
                if ((tagType = CMHtmlHelper.getHTMLTagType(tagName)) == 0 && i < splitStr.length - 1 && splitStr[i + 1].charAt(0) == '<') {
                    tagType = -1;
                }
                switch (tagType) {
                    case 0: {
                        isTag = true;
                        break;
                    }
                    case 1: {
                        isTag = true;
                        removeContent = true;
                        break;
                    }
                    case 2: {
                        isTag = true;
                        commented = true;
                        break;
                    }
                    case -1: {
                        if (i > 0 && (splitStr[i - 1].charAt(0) == '>' || splitStr[i - 1].charAt(0) == '<')) {
                            strippedStr.append(splitStr[i - 1]);
                        } else {
                            strippedStr.append("<");
                        }
                        if (storedSlash) {
                            strippedStr.append("/");
                        }
                        strippedStr.append(line);
                    }
                }
                checkTag = false;
                continue;
            }
            if (isTag || removeContent) continue;
            strippedStr.append(line);
        }
        if (checkTag) {
            strippedStr.append(line);
        }
        return strippedStr.toString();
    }

    private static boolean isValidTag(String tag) {
        int tagType;
        String tagName = tag.trim().toLowerCase();
        int spacePos = tagName.indexOf(32);
        if (spacePos >= 0) {
            tagName = tagName.substring(0, spacePos);
        }
        return (tagType = CMHtmlHelper.getHTMLTagType(tagName)) != -1;
    }

    private static String stripJavaScript(String str) {
        for (int i = 0; i < supportJSCmd.length; ++i) {
            str = CMHtmlHelper.stripJSCmd(str, supportJSCmd[i]);
        }
        return str;
    }

    private static String stripJSCmd(String str, String jsCmd) {
        String lowerCaseStr = str.toLowerCase();
        int jsIndex = lowerCaseStr.indexOf(jsCmd);
        if (jsIndex != -1) {
            String preStr = str.substring(0, jsIndex);
            String sufStr = str.substring(jsIndex + jsCmd.length(), str.length());
            String[] Strings = CMStringHelper.split(sufStr, '\"', false);
            if (Strings.length > 2) {
                int i;
                int nonEscapeQuoteCount = 0;
                int index = 0;
                for (i = 0; i < Strings.length; ++i) {
                    String checkStr = Strings[i];
                    if (checkStr.length() <= 1) {
                        ++nonEscapeQuoteCount;
                    } else if (checkStr.charAt(checkStr.length() - 2) != '\\') {
                        ++nonEscapeQuoteCount;
                    }
                    if (nonEscapeQuoteCount != 2) continue;
                    index = i + 1;
                    break;
                }
                if (nonEscapeQuoteCount == 2) {
                    sufStr = "";
                    for (i = index; i < Strings.length; ++i) {
                        sufStr = sufStr + Strings[i];
                        if (i >= Strings.length - 1) continue;
                        sufStr = sufStr + "\"";
                    }
                    sufStr = CMHtmlHelper.stripJSCmd(sufStr, jsCmd);
                }
                str = preStr + sufStr;
            }
        }
        return str;
    }

    public static boolean hasHTMLTag(String str) {
        String[] htmlDelimiters = new String[]{"<", ">"};
        String[] splitStr = CMStringHelper.split(str, htmlDelimiters, false, true);
        String line = null;
        for (int i = 0; i < splitStr.length; ++i) {
            line = splitStr[i];
            String tagName = line.trim().toLowerCase();
            int spacePos = tagName.indexOf(32);
            if (spacePos >= 0) {
                tagName = tagName.substring(0, spacePos);
            }
            int tagType = CMHtmlHelper.getHTMLTagType(tagName);
            switch (tagType) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }
}

