/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mobile.common;

import com.cognos.mobile.vm.IVMImage;
import com.cognos.mobile.vm.VMColor;

public class CMImageHelper {
    public static void shrinkImageUsingLessMemory(int cxSource, int cySource, IVMImage source, int cxDest, int cyDest, IVMImage dest) {
        double factorX = (double)cxSource / (double)cxDest;
        int cxSourceBoxHalf = (int)(factorX / 2.0 + 1.0);
        int cxSourceBox = 2 * cxSourceBoxHalf;
        double factorY = (double)cySource / (double)cyDest;
        int cySourceBoxHalf = (int)(factorY / 2.0 + 1.0);
        int cySourceBox = 2 * cySourceBoxHalf;
        int[] sourceRGB = new int[cxSourceBox * cySourceBox];
        int[] destRGB = new int[cxDest];
        for (int y = 0; y < cyDest; ++y) {
            for (int x = 0; x < cxDest; ++x) {
                int startX = x * cxSourceBox - cxSourceBoxHalf;
                startX = startX < 0 ? 0 : startX;
                int startY = y * cySourceBox - cySourceBoxHalf;
                startY = startY < 0 ? 0 : startY;
                source.onImageGetRGB(sourceRGB, 0, cxSourceBox, startX, startY, cxSourceBox, cySourceBox);
                destRGB[x] = CMImageHelper.findAverageColor(sourceRGB, cxSourceBox, 0, 0, cxSourceBox, cySourceBox);
            }
            dest.onImageSetRGB(destRGB, 0, cxDest, 0, y, cxDest, 1);
        }
    }

    public static void shrinkImage(int cxSource, int cySource, IVMImage source, int cxDest, int cyDest, IVMImage dest) {
        double factor = (double)cxSource / (double)cxDest;
        int cySourceRow = (int)(factor + 1.0);
        int[] sourceRGB = new int[cySourceRow * cxSource];
        int[] destRGB = new int[cxDest];
        int yStart = -1;
        int yStop = -1;
        double yStopD = -factor / 2.0;
        for (int y = 0; y < cyDest; ++y) {
            int x;
            int lastUsedX = -1;
            int xStart = -1;
            int xStop = -1;
            double xStopD = -factor / 2.0;
            yStart = yStop + 1;
            if (yStart > (yStop = Math.min(cySource - 1, (int)(yStopD += factor) + 1))) continue;
            int cyRow = yStop - yStart + 1;
            source.onImageGetRGB(sourceRGB, 0, cxSource, 0, yStart, cxSource, cyRow);
            for (x = 0; x < cxDest; ++x) {
                int average;
                xStart = xStop + 1;
                if (xStart > (xStop = Math.min(cxSource - 1, (int)(xStopD += factor) + 1))) continue;
                lastUsedX = x;
                destRGB[x] = average = CMImageHelper.findAverageColor(sourceRGB, cxSource, xStart, 0, xStop - xStart + 1, cyRow);
            }
            for (x = lastUsedX + 1; x < cxDest; ++x) {
                destRGB[x] = VMColor.DEFAULT_BACK_COLOR;
            }
            dest.onImageSetRGB(destRGB, 0, cxDest, 0, y, cxDest, 1);
        }
    }

    public static void enlargeImage(int cxSource, int cySource, IVMImage source, int cxDest, int cyDest, IVMImage dest) {
        CMImageHelper.resizeImage(cxSource, cySource, source, cxDest, cyDest, dest);
    }

    private static int findAverageColor(int[] rgb, int scanLength, int x, int y, int cx, int cy) {
        int totalr = 0;
        int totalg = 0;
        int totalb = 0;
        for (int dy = 0; dy < cy; ++dy) {
            int index = (y + dy) * scanLength + x;
            for (int dx = 0; dx < cx; ++dx) {
                int color = rgb[index];
                ++index;
                totalb += color & 0xFF;
                totalg += (color >>= 8) & 0xFF;
                totalr += (color >>= 8) & 0xFF;
            }
        }
        int count = cx * cy;
        int average = totalr / count & 0xFF;
        average <<= 8;
        average |= totalg / count & 0xFF;
        average <<= 8;
        return average |= totalb / count & 0xFF;
    }

    private static void resizeImage(int cxSource, int cySource, IVMImage source, int cxDest, int cyDest, IVMImage dest) {
        int[] sourceRGB = new int[cxSource];
        int[] destRGB = new int[cxDest];
        int rz = 0;
        int dy = 0;
        for (int y = 0; y < cySource; ++y) {
            source.onImageGetRGB(sourceRGB, 0, cxSource, 0, y, cxSource, 1);
            rz += cyDest;
            while (rz >= cySource) {
                int cz = 0;
                int dx = 0;
                for (int x = 0; x < cxSource; ++x) {
                    cz += cxDest;
                    while (cz >= cxSource) {
                        destRGB[dx] = sourceRGB[x];
                        ++dx;
                        cz -= cxSource;
                    }
                }
                dest.onImageSetRGB(destRGB, 0, cxDest, 0, dy, cxDest, 1);
                ++dy;
                rz -= cySource;
            }
        }
    }
}

